/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.items;

import java.util.List;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.items.GenericRFToolsItem;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PhasedFieldGeneratorItem
extends GenericRFToolsItem
implements IEnergyItem {
    private long capacity;
    private long maxReceive;
    private long maxExtract;

    public PhasedFieldGeneratorItem() {
        super("phased_field_generator");
        this.func_77625_d(1);
        this.capacity = PowerConfiguration.PHASEDFIELD_MAXENERGY;
        this.maxReceive = PowerConfiguration.PHASEDFIELD_RECEIVEPERTICK;
        this.maxExtract = PowerConfiguration.PHASEDFIELD_CONSUMEPERTICK * 10;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 8; ++i) {
            ResourceLocation registryName = this.getRegistryName();
            registryName = new ResourceLocation(registryName.func_110624_b(), registryName.func_110623_a() + i);
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(registryName, "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            long level;
            NBTTagCompound tagCompound = stack.func_77978_p();
            long energy = 0L;
            if (tagCompound != null) {
                energy = tagCompound.func_74763_f("Energy");
            }
            if ((level = 9L * energy / (long)PowerConfiguration.PHASEDFIELD_MAXENERGY) < 0L) {
                level = 0L;
            } else if (level > 8L) {
                level = 8L;
            }
            ResourceLocation registryName = this.getRegistryName();
            registryName = new ResourceLocation(registryName.func_110624_b(), registryName.func_110623_a() + (8L - level));
            return new ModelResourceLocation(registryName, "inventory");
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_190926_b() != newStack.func_190926_b()) {
            return true;
        }
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.BLUE + "Energy: " + tagCompound.func_74763_f("Energy") + " RF");
        }
        list.add("This RF/charged module gives a temporary");
        list.add("protection while visiting an unpowered dimension.");
        list.add("Use at your own risk and don't let power run out!");
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        long energy = container.func_77978_p().func_74763_f("Energy");
        long energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74772_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        long energy = container.func_77978_p().func_74763_f("Energy");
        long energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74772_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0L;
        }
        return container.func_77978_p().func_74763_f("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return this.capacity;
    }
}

