/*
 * Decompiled with CFR 0.152.
 */
package extracells.models;

import appeng.api.AEApi;
import appeng.api.parts.IPartModel;
import appeng.api.parts.IPartModels;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public enum PartModels implements IPartModel
{
    EXPORT_BASE("export_base"),
    EXPORT_HAS_CHANNEL(new Object[]{EXPORT_BASE, "export_has_channel"}),
    EXPORT_OFF(new Object[]{EXPORT_BASE, "export_off"}),
    EXPORT_ON(new Object[]{EXPORT_BASE, "export_on"}),
    IMPORT_BASE("import_base"),
    IMPORT_HAS_CHANNEL(new Object[]{IMPORT_BASE, "import_has_channel"}),
    IMPORT_OFF(new Object[]{IMPORT_BASE, "import_off"}),
    IMPORT_ON(new Object[]{IMPORT_BASE, "import_on"}),
    DISPLAY_BASE("display_base"),
    TERMINAL_OFF(new Object[]{DISPLAY_BASE, "display_status_off", "terminal_off"}),
    TERMINAL_ON(new Object[]{DISPLAY_BASE, "display_status_on", "terminal_on"}),
    TERMINAL_HAS_CHANNEL(new Object[]{TERMINAL_ON, "display_has_channel"}),
    EMITTER_BASE_OFF("emitter_base_off"),
    EMITTER_BASE_ON("emitter_base_on"),
    EMITTER_OFF_OFF(new Object[]{EMITTER_BASE_OFF, "emitter_status_off"}),
    EMITTER_OFF_ON(new Object[]{EMITTER_BASE_OFF, "emitter_status_on"}),
    EMITTER_OFF_HAS_CHANNEL(new Object[]{EMITTER_BASE_OFF, "emitter_status_has_channel"}),
    EMITTER_ON_OFF(new Object[]{EMITTER_BASE_ON, "emitter_status_off"}),
    EMITTER_ON_ON(new Object[]{EMITTER_BASE_ON, "emitter_status_on"}),
    EMITTER_ON_HAS_CHANNEL(new Object[]{EMITTER_BASE_ON, "emitter_status_has_channel"}),
    STORAGE_BUS_BASE("storage_bus"),
    STORAGE_BUS_OFF(new Object[]{STORAGE_BUS_BASE, "storage_bus_off"}),
    STORAGE_BUS_ON(new Object[]{STORAGE_BUS_BASE, "storage_bus_on"}),
    STORAGE_BUS_HAS_CHANNEL(new Object[]{STORAGE_BUS_BASE, "storage_bus_has_channel"}),
    STORAGE_INTERFACE_BASE("storage_interface"),
    STORAGE_INTERFACE_OFF(new Object[]{STORAGE_INTERFACE_BASE, "storage_interface_off"}),
    STORAGE_INTERFACE_ON(new Object[]{STORAGE_INTERFACE_BASE, "storage_interface_on"}),
    STORAGE_INTERFACE_HAS_CHANNEL(new Object[]{STORAGE_INTERFACE_BASE, "storage_interface_has_channel"}),
    PLANE_OFF("plane_off"),
    PLANE_ON("plane_on"),
    PLANE_HAS_CHANNEL("plane_status_has_channel"),
    ANNIHILATION_PLANE_BASE("annihilation_plane_base"),
    ANNIHILATION_PLANE_OFF(new Object[]{ANNIHILATION_PLANE_BASE, PLANE_OFF}),
    ANNIHILATION_PLANE_ON(new Object[]{ANNIHILATION_PLANE_BASE, PLANE_OFF}),
    ANNIHILATION_PLANE_HAS_CHANNEL(new Object[]{ANNIHILATION_PLANE_BASE, PLANE_HAS_CHANNEL}),
    FORMATION_PLANE_BASE("formation_plane_base"),
    FORMATION_PLANE_OFF(new Object[]{FORMATION_PLANE_BASE, PLANE_OFF}),
    FORMATION_PLANE_ON(new Object[]{FORMATION_PLANE_BASE, PLANE_OFF}),
    FORMATION_PLANE_HAS_CHANNEL(new Object[]{FORMATION_PLANE_BASE, PLANE_HAS_CHANNEL}),
    BATTERY_BASE("battery_base"),
    BATTERY_PLANE_OFF(new Object[]{BATTERY_BASE, PLANE_OFF}),
    BATTERY_PLANE_ON(new Object[]{BATTERY_BASE, PLANE_OFF}),
    BATTERY_PLANE_HAS_CHANNEL(new Object[]{BATTERY_BASE, PLANE_HAS_CHANNEL}),
    DRIVE_BASE("drive"),
    DRIVE_ON(new Object[]{DRIVE_BASE, PLANE_ON}),
    DRIVE_OFF(new Object[]{DRIVE_BASE, PLANE_OFF}),
    DRIVE_HAS_CHANNEL(new Object[]{DRIVE_BASE, PLANE_HAS_CHANNEL}),
    MONITOR_BASE("monitor_base"),
    MONITOR_OFF("monitor_off"),
    MONITOR_ON("monitor_on"),
    MONITOR_HAS_CHANNEL("monitor_has_channel"),
    STORAGE_MONITOR_OFF(new Object[]{MONITOR_BASE, MONITOR_OFF, "storage_monitor_off"}),
    STORAGE_MONITOR_ON(new Object[]{MONITOR_BASE, MONITOR_ON, "storage_monitor_on"}),
    STORAGE_MONITOR_HAS_CHANNEL(new Object[]{MONITOR_BASE, MONITOR_HAS_CHANNEL, "storage_monitor_on"}),
    CONVERSION_MONITOR_OFF(new Object[]{MONITOR_BASE, MONITOR_OFF, "conversion_monitor_off"}),
    CONVERSION_MONITOR_ON(new Object[]{MONITOR_BASE, MONITOR_ON, "conversion_monitor_on"}),
    CONVERSION_MONITOR_HAS_CHANNEL(new Object[]{MONITOR_BASE, MONITOR_HAS_CHANNEL, "conversion_monitor_on"});

    boolean requireConnection;
    List<ResourceLocation> locations;

    private PartModels(Object ... modelNames) {
        this(true, modelNames);
    }

    private PartModels(boolean requireConnection, Object ... modelNames) {
        this.requireConnection = requireConnection;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Object o : modelNames) {
            if (o instanceof IPartModel) {
                builder.addAll((Iterable)((IPartModel)o).getModels());
                continue;
            }
            builder.add((Object)new ResourceLocation("extracells", "part/" + o.toString()));
        }
        this.locations = builder.build();
    }

    public boolean requireCableConnection() {
        return this.requireConnection;
    }

    @Nonnull
    public List<ResourceLocation> getModels() {
        return this.locations;
    }

    public static void registerModels() {
        IPartModels partModels = AEApi.instance().registries().partModels();
        for (PartModels model : PartModels.values()) {
            partModels.registerModels(model.getModels());
        }
    }
}

