/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.waila;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import extracells.part.PartECBase;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class PartWailaDataProvider
implements IWailaDataProvider {
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        IPart part;
        RayTraceResult mop = this.retraceBlock(world, player, pos);
        if (mop != null && (part = this.getPart(te, mop)) != null && part instanceof PartECBase) {
            tag.func_74782_a("partEC", (NBTBase)((PartECBase)part).getWailaTag(new NBTTagCompound()));
        }
        return tag;
    }

    private IPart getPart(TileEntity tile, RayTraceResult traceResult) {
        if (tile instanceof IPartHost) {
            Vec3d position = traceResult.field_72307_f.func_178788_d(new Vec3d((Vec3i)traceResult.func_178782_a()));
            IPartHost host = (IPartHost)tile;
            SelectedPart sp2 = host.selectPart(position);
            if (sp2.part != null) {
                return sp2.part;
            }
        }
        return null;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity tile = accessor.getTileEntity();
        IPart part = this.getPart(tile, accessor.getMOP());
        if (part != null && part instanceof PartECBase) {
            NBTTagCompound tag = accessor.getNBTData() != null && accessor.getNBTData().func_74764_b("partEC") ? accessor.getNBTData().func_74775_l("partEC") : new NBTTagCompound();
            return ((PartECBase)part).getWailaBodey(tag, currenttip);
        }
        return currenttip;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    private RayTraceResult retraceBlock(World world, EntityPlayerMP player, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Vec3d head = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v).func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        if (player.func_70093_af()) {
            head = head.func_72441_c(0.0, -0.08, 0.0);
        }
        Vec3d look = player.func_70676_i(1.0f);
        double reach = player.field_71134_c.getBlockReachDistance();
        Vec3d endVec = head.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        return blockState.func_185910_a(world, pos, head, endVec);
    }
}

