/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.ae2utilities.proxy;

import appeng.block.AEBaseItemBlock;
import appeng.block.AEBaseTileBlock;
import appeng.core.features.ActivityState;
import appeng.core.features.BlockStackSrc;
import appeng.core.features.IStackSrc;
import appeng.tile.AEBaseTile;
import com.github.vfyjxf.ae2utilities.block.BlockEnhancedInterface;
import com.github.vfyjxf.ae2utilities.item.ItemPartEnhancedInterfaceTier1;
import com.github.vfyjxf.ae2utilities.item.ItemPartEnhancedInterfaceTier2;
import com.github.vfyjxf.ae2utilities.item.ItemPartEnhancedInterfaceTier3;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier1;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier2;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="ae2utilities")
public class RegistryHandler {
    public static final RegistryHandler INSTANCE = new RegistryHandler();
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<Item> items = new ArrayList<Item>();

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        for (Item item : INSTANCE.getItems()) {
            if (item == null) continue;
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        for (Block block : INSTANCE.getBlocks()) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        GameRegistry.registerTileEntity(TileEnhancedInterfaceTier1.class, (ResourceLocation)new ResourceLocation("ae2utilities", "enhanced_interface_1"));
        GameRegistry.registerTileEntity(TileEnhancedInterfaceTier2.class, (ResourceLocation)new ResourceLocation("ae2utilities", "enhanced_interface_2"));
        GameRegistry.registerTileEntity(TileEnhancedInterfaceTier3.class, (ResourceLocation)new ResourceLocation("ae2utilities", "enhanced_interface_3"));
    }

    public void initBlocks() {
        for (int i = 1; i <= 3; ++i) {
            BlockEnhancedInterface block = new BlockEnhancedInterface(i);
            String registryName = "ae2utilities:enhanced_interface_tier" + i;
            block.setRegistryName(registryName);
            block.func_149663_c("ae2utilities.enhanced_interface_tier" + i);
            this.blocks.add((Block)block);
            Item item = (Item)new AEBaseItemBlock((Block)block).setRegistryName(registryName);
            this.items.add(item);
        }
    }

    public void initItems() {
        this.items.add(this.initItem(new ItemPartEnhancedInterfaceTier1(), "part_enhanced_interface_tier1"));
        this.items.add(this.initItem(new ItemPartEnhancedInterfaceTier2(), "part_enhanced_interface_tier2"));
        this.items.add(this.initItem(new ItemPartEnhancedInterfaceTier3(), "part_enhanced_interface_tier3"));
    }

    private Item initItem(Item item, String registryName) {
        item.setRegistryName("ae2utilities:" + registryName);
        item.func_77655_b("ae2utilities." + registryName);
        return item;
    }

    public void onInit() {
        for (Block block : this.getBlocks()) {
            if (!(block instanceof AEBaseTileBlock)) continue;
            AEBaseTile.registerTileItem((Class)((AEBaseTileBlock)block).getTileEntityClass(), (IStackSrc)new BlockStackSrc(block, 0, ActivityState.Enabled));
        }
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Item> getItems() {
        return this.items;
    }
}

