/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.ae2utilities.parts;

import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.sync.GuiBridge;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.IPriorityHost;
import appeng.parts.PartBasicState;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.InvOperation;
import com.github.vfyjxf.ae2utilities.helper.DualityEnhancedInterface;
import com.github.vfyjxf.ae2utilities.network.Ae2uGuiHandler;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public abstract class PartEnhancedInterfaceBase
extends PartBasicState
implements IGridTickable,
IStorageMonitorable,
IInventoryDestination,
IInterfaceHost,
IAEAppEngInventory,
IPriorityHost {
    private final DualityEnhancedInterface duality = new DualityEnhancedInterface(this.getProxy(), this, this.getTier());

    public PartEnhancedInterfaceBase(ItemStack is) {
        super(is);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.duality.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.duality.notifyNeighbors();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    public void gridChanged() {
        this.duality.gridChanged();
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.duality.readFromNBT(data);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.duality.writeToNBT(data);
    }

    public void addToWorld() {
        super.addToWorld();
        this.duality.initialize();
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        this.duality.addDrops(drops);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    public IItemHandler getInventoryByName(String name) {
        return this.duality.getInventoryByName(name);
    }

    public boolean onPartActivate(EntityPlayer p, EnumHand hand, Vec3d pos) {
        if (Platform.isServer()) {
            Ae2uGuiHandler.openGui(p, this.getTier(), this.getTileEntity(), this.getSide());
        }
        return true;
    }

    public boolean canInsert(ItemStack stack) {
        return this.duality.canInsert(stack);
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        return this.duality.getInventory(channel);
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return this.duality.getTickingRequest(node);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.duality.tickingRequest(node, ticksSinceLastCall);
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.duality.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    public DualityInterface getInterfaceDuality() {
        return this.duality;
    }

    public EnumSet<EnumFacing> getTargets() {
        return EnumSet.of(this.getSide().getFacing());
    }

    public TileEntity getTileEntity() {
        return super.getHost().getTile();
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.duality.pushPattern(patternDetails, table);
    }

    public boolean isBusy() {
        return this.duality.isBusy();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.duality.provideCrafting(craftingTracker);
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.duality.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.duality.injectCraftedItems(link, items, mode);
    }

    public void jobStateChange(ICraftingLink link) {
        this.duality.jobStateChange(link);
    }

    public int getPriority() {
        return this.duality.getPriority();
    }

    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }

    @Nonnull
    public abstract IPartModel getStaticModels();

    public boolean hasCapability(Capability<?> capabilityClass) {
        return this.duality.hasCapability(capabilityClass, this.getSide().getFacing());
    }

    public <T> T getCapability(Capability<T> capabilityClass) {
        return (T)this.duality.getCapability(capabilityClass, this.getSide().getFacing());
    }

    public abstract ItemStack getItemStackRepresentation();

    public GuiBridge getGuiBridge() {
        return GuiBridge.GUI_Handler;
    }

    public abstract int getTier();
}

