/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.ae2utilities.network.packets;

import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import com.github.vfyjxf.ae2utilities.network.Ae2uGuiHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSwitchGuis
implements IMessage {
    private int guiId;
    private boolean isAeGui;

    public PacketSwitchGuis() {
    }

    public PacketSwitchGuis(int guiId) {
        this.guiId = guiId;
        this.isAeGui = false;
    }

    public PacketSwitchGuis(int guiId, boolean isAeGui) {
        this.guiId = guiId;
        this.isAeGui = isAeGui;
    }

    public void fromBytes(ByteBuf buf) {
        this.guiId = buf.readInt();
        this.isAeGui = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.guiId);
        buf.writeBoolean(this.isAeGui);
    }

    public static class Handler
    implements IMessageHandler<PacketSwitchGuis, IMessage> {
        public IMessage onMessage(PacketSwitchGuis message, MessageContext ctx) {
            ContainerOpenContext context;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (message.isAeGui && container instanceof AEBaseContainer && (context = ((AEBaseContainer)container).getOpenContext()) != null) {
                TileEntity te = context.getTile();
                Ae2uGuiHandler.openGui((EntityPlayer)player, message.guiId, te, message.isAeGui ? context.getSide() : AEPartLocation.INTERNAL);
            }
            return null;
        }
    }
}

