/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.util;

public class Kernel {
    public final double[] array;
    public final int radius;
    public final int size;

    public Kernel(int radius, IKernelFormula formula, boolean norm) {
        this.radius = radius;
        this.size = radius * 2 + 1;
        this.array = new double[this.size * this.size];
        double total = 0.0;
        for (int ix = 0; ix < this.size; ++ix) {
            for (int iz = 0; iz < this.size; ++iz) {
                double n;
                int index = iz * this.size + ix;
                int x = ix - this.radius;
                int z = iz - this.radius;
                this.array[index] = n = formula.operation(x, z);
                total += n;
            }
        }
        if (norm && total != 0.0) {
            int i = 0;
            while (i < this.array.length) {
                int n = i++;
                this.array[n] = this.array[n] / total;
            }
        }
    }

    public Kernel(int radius, IKernelFormula formula) {
        this(radius, formula, true);
    }

    public double getValue(int x, int z) {
        if (Math.abs(x) > this.radius || Math.abs(z) > this.radius) {
            return 0.0;
        }
        return this.array[(z + this.radius) * this.size + (x + this.radius)];
    }

    public static interface IKernelFormula {
        public double operation(int var1, int var2);
    }
}

