/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import kenijey.rwg.RWG;

public abstract class JsonUtil {
    public static final JsonParser PARSER = new JsonParser();

    public static <T> T get(JsonObject json, String tag, T fallback) {
        if (!json.has(tag) || json.get(tag) == null) {
            RWG.logger.warn("Json parsing: tag " + tag + " is empty");
            return fallback;
        }
        return JsonUtil.as(json.get(tag), fallback);
    }

    public static <T> T as(JsonElement element, T fallback) {
        T val = fallback;
        try {
            val = JsonUtil.getValue(element, fallback);
        }
        catch (ClassCastException | IllegalStateException e) {
            RWG.logger.warn("Incorrect value type: " + fallback.getClass() + ", falling back to " + fallback);
        }
        catch (IllegalArgumentException e) {
            RWG.logger.warn("Unhandled fallback type: " + fallback.getClass());
        }
        return val;
    }

    private static <T> T getValue(JsonElement element, T compared) throws IllegalStateException, ClassCastException, IllegalArgumentException {
        if (compared instanceof Double) {
            return (T)new Double(element.getAsDouble());
        }
        if (compared instanceof Integer) {
            return (T)new Integer(element.getAsInt());
        }
        if (compared instanceof JsonObject) {
            return (T)element.getAsJsonObject();
        }
        if (compared instanceof JsonArray) {
            return (T)element.getAsJsonArray();
        }
        if (compared instanceof String) {
            return (T)element.getAsString();
        }
        if (compared instanceof Boolean) {
            return (T)new Boolean(element.getAsBoolean());
        }
        throw new IllegalArgumentException();
    }

    public static JsonObject getAsObject(JsonObject json, String tag) {
        return JsonUtil.get(json, tag, new JsonObject());
    }

    public static JsonObject asObject(JsonElement element) {
        return JsonUtil.as(element, new JsonObject());
    }

    public static JsonArray getAsArray(JsonObject json, String tag) {
        return JsonUtil.get(json, tag, new JsonArray());
    }

    public static JsonArray asArray(JsonElement element) {
        return JsonUtil.as(element, new JsonArray());
    }
}

