/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.util;

import kenijey.rwg.RWG;
import kenijey.rwg.generator.BiomeProviderRWG;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public abstract class GeneralUtil {
    public static BiomeProviderRWG getRWGBiomeProvider(World world) {
        BiomeProvider provider = world.func_72959_q();
        if (provider instanceof BiomeProviderRWG) {
            return (BiomeProviderRWG)provider;
        }
        return null;
    }

    public static boolean isWorldRWG(World world) {
        return world.func_175624_G() == RWG.worldType;
    }

    public static String padString(String in, char pad, int toLength, boolean clip) {
        if (in.length() < toLength) {
            for (int i = in.length(); i < toLength; ++i) {
                in = in + pad;
            }
        } else if (clip && in.length() > toLength) {
            return in.substring(0, toLength - 1);
        }
        return in;
    }

    public static String padString(String in, char pad, int toLength) {
        return GeneralUtil.padString(in, pad, toLength, false);
    }

    public static void printBiomeInformation() {
        RWG.logger.info("-------------------------------------------------------------------------------------------------------------");
        RWG.logger.info("Biome Information");
        RWG.logger.info("-------------------------------------------------------------------------------------------------------------");
        RWG.logger.info("ID  | Location                                           | Name");
        for (int id = 0; id < 256; ++id) {
            Biome biome = Biome.func_150568_d((int)id);
            String name = "-";
            String prettyName = "-";
            if (biome != null) {
                name = biome.getRegistryName().toString();
                prettyName = biome.func_185359_l();
            }
            String output = "" + id;
            output = GeneralUtil.padString(output, ' ', 3);
            output = output + " | ";
            output = output + GeneralUtil.padString(prettyName, ' ', 50);
            output = output + " | ";
            output = output + GeneralUtil.padString(name, ' ', 50);
            RWG.logger.info(output);
        }
        RWG.logger.info("-------------------------------------------------------------------------------------------------------------");
    }
}

