/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kenijey.rwg.util.CoordPair;
import kenijey.rwg.util.MathUtil;

public class CoordCache<T extends CoordPair> {
    public final long size;
    public long collisions = 0L;
    private Map<Integer, T> cache;

    public CoordCache(long size) {
        this.size = size;
        this.cache = Collections.synchronizedMap(new CacheMap());
    }

    public T get(int x, int z) {
        CoordPair entry = (CoordPair)this.cache.get(MathUtil.coordHash(x, z));
        if (entry != null && (entry.x != x || entry.z != z)) {
            ++this.collisions;
            return null;
        }
        return (T)entry;
    }

    public T put(int x, int z, T value) {
        this.cache.put(MathUtil.coordHash(x, z), value);
        return value;
    }

    private class CacheMap<U>
    extends LinkedHashMap<Integer, U> {
        private CacheMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, U> eldest) {
            return (long)this.size() > CoordCache.this.size;
        }
    }
}

