/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.tweaks;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import kenijey.rwg.RWG;
import kenijey.rwg.util.GeneralUtil;
import kenijey.rwg.util.MathUtil;
import kenijey.rwg.util.ObfuscationReflectionHelperEx;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GrassColours {
    private static final String[] COLOR_RESOLVER = new String[]{"ais$a", "net.minecraft.world.biome.BiomeColorHelper$ColorResolver"};
    private static final String[] GET_COLOR_AT_POS = new String[]{"a", "getColorAtPos", "func_180285_a"};
    public static LoadingCache<GrassCacheKey, Biome> grassCache;

    public static void init() {
        RWG.logger.info("ATTEMPTING TO COMMIT GREAT EVIL:");
        try {
            GrassColours.doImmenseEvil();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        MinecraftForge.EVENT_BUS.register((Object)new Listener());
        grassCache = CacheBuilder.newBuilder().maximumSize(2048L).build((CacheLoader)new CacheLoader<GrassCacheKey, Biome>(){

            public Biome load(GrassCacheKey key) {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world.field_73011_w.getDimension() == key.dim) {
                    return world.func_180494_b(new BlockPos(key.x, 63, key.z));
                }
                return Biomes.field_180279_ad;
            }
        });
    }

    public static void doImmenseEvil() throws Exception {
        Field grass_color = ObfuscationReflectionHelperEx.findField(BiomeColorHelper.class, "GRASS_COLOR");
        grass_color.setAccessible(true);
        Field modifiers = Field.class.getDeclaredField("modifiers");
        AccessController.doPrivileged(() -> {
            modifiers.setAccessible(true);
            return null;
        });
        modifiers.setInt(grass_color, grass_color.getModifiers() & 0xFFFFFFEF);
        Class colorResolver = ReflectionHelper.getClass((ClassLoader)Minecraft.class.getClassLoader(), (String[])COLOR_RESOLVER);
        Object wrappedResolver = grass_color.get(null);
        Class<?> wrappedResolverClass = wrappedResolver.getClass();
        Method wrappedGetColorAtPos = ReflectionHelper.findMethod(wrappedResolverClass, (String)GET_COLOR_AT_POS[1], (String)GET_COLOR_AT_POS[2], (Class[])new Class[]{Biome.class, BlockPos.class});
        Method getColorAtPos = ReflectionHelper.findMethod((Class)colorResolver, (String)GET_COLOR_AT_POS[1], (String)GET_COLOR_AT_POS[2], (Class[])new Class[]{Biome.class, BlockPos.class});
        Object proxy = Proxy.newProxyInstance(colorResolver.getClassLoader(), new Class[]{colorResolver}, (InvocationHandler)new GrassHandler(getColorAtPos, wrappedResolver, wrappedGetColorAtPos));
        grass_color.set(null, proxy);
    }

    public static void clearCache() {
        grassCache.invalidateAll();
    }

    public static int getGrassColour(World world, Biome biome, BlockPos pos) {
        int rad = 5;
        int divisor = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int chunkx = Math.floorDiv(pos.func_177958_n(), 16);
        int chunkz = Math.floorDiv(pos.func_177952_p(), 16);
        int cx = pos.func_177958_n() - chunkx * 16;
        int cz = pos.func_177952_p() - chunkz * 16;
        if (cx <= rad) {
            --chunkx;
            cx += 16;
        }
        if (cz <= rad) {
            --chunkz;
            cz += 16;
        }
        Chunk[][] chunks = new Chunk[][]{{world.func_72964_e(chunkx, chunkz), world.func_72964_e(chunkx, chunkz + 1)}, {world.func_72964_e(chunkx + 1, chunkz), world.func_72964_e(chunkx + 1, chunkz + 1)}};
        BlockPos.MutableBlockPos ipos = new BlockPos.MutableBlockPos();
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                Chunk chunk;
                int bx = cx + x;
                int bz = cz + z;
                int ix = Math.floorDiv(bx, 16);
                int iz = Math.floorDiv(bz, 16);
                if (ix > 0) {
                    bx -= 16;
                }
                if (iz > 0) {
                    bz -= 16;
                }
                if ((chunk = chunks[ix][iz]) == null) continue;
                ipos.func_181079_c(pos.func_177958_n() + x, 0, pos.func_177952_p() + z);
                Biome ib = Biome.func_150568_d((int)chunk.func_76605_m()[bz * 16 + bx]);
                if (ib == null) {
                    ib = Biomes.field_180279_ad;
                }
                int col = ib.func_180627_b((BlockPos)ipos);
                r += (col & 0xFF0000) >> 16;
                g += (col & 0xFF00) >> 8;
                b += col & 0xFF;
                ++divisor;
            }
        }
        if (divisor == 0) {
            return 0xFF00FF;
        }
        return (r / divisor & 0xFF) << 16 | (g / divisor & 0xFF) << 8 | b / divisor & 0xFF;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Listener {
        @SubscribeEvent
        public void login(PlayerEvent.PlayerLoggedInEvent event) {
            this.clearCache((PlayerEvent)event);
        }

        @SubscribeEvent
        public void logout(PlayerEvent.PlayerLoggedOutEvent event) {
            this.clearCache((PlayerEvent)event);
        }

        public void clearCache(PlayerEvent event) {
            if (event.player.field_70170_p.field_72995_K && event.player == Minecraft.func_71410_x().field_71439_g) {
                GrassColours.clearCache();
            }
        }
    }

    public static class GrassCacheKey {
        public final int x;
        public final int z;
        public final int dim;

        public GrassCacheKey(int x, int z, int dim) {
            this.x = x;
            this.z = z;
            this.dim = dim;
        }

        public GrassCacheKey(World world, BlockPos pos) {
            this(pos.func_177958_n(), pos.func_177952_p(), world.field_73011_w.getDimension());
        }

        public boolean equals(Object other) {
            if (!(other instanceof GrassCacheKey)) {
                return false;
            }
            GrassCacheKey o = (GrassCacheKey)other;
            return this.x == o.x && this.z == o.z && this.dim == o.dim;
        }

        public int hashCode() {
            return this.dim << 13 ^ MathUtil.coordHash(this.x, this.z);
        }
    }

    private static class GrassHandler
    implements InvocationHandler {
        public final Method abstractGetColorAtPos;
        public final Object wrappedResolver;
        public final Method wrappedGetColorAtPos;

        public GrassHandler(Method abstractGetColorAtPos, Object wrappedResolver, Method wrappedGetColorAtPos) {
            this.abstractGetColorAtPos = abstractGetColorAtPos;
            this.abstractGetColorAtPos.setAccessible(true);
            this.wrappedResolver = wrappedResolver;
            this.wrappedGetColorAtPos = wrappedGetColorAtPos;
            RWG.logger.info((Object)abstractGetColorAtPos);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(this.abstractGetColorAtPos)) {
                Biome probe;
                Biome biome = (Biome)args[0];
                BlockPos pos = (BlockPos)args[1];
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world != null && GeneralUtil.isWorldRWG((World)world) && (probe = world.func_180494_b(pos)) == biome) {
                    return GrassColours.getGrassColour((World)world, biome, pos);
                }
                if (this.wrappedResolver != null) {
                    return this.wrappedGetColorAtPos.invoke(this.wrappedResolver, biome, pos);
                }
                return 0xFF00FF;
            }
            return method.invoke(this.wrappedResolver, args);
        }
    }
}

