/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kenijey.rwg.RWG;
import kenijey.rwg.settings.BiomeSettings;
import kenijey.rwg.settings.ChunkGeneratorSettings;
import kenijey.rwg.settings.DefaultWorldSettings;
import kenijey.rwg.settings.Settings;
import kenijey.rwg.util.JsonUtil;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class WorldSettings
extends Settings {
    public BiomeSettings biomeSettings = new BiomeSettings();
    public ChunkGeneratorSettings genSettings = new ChunkGeneratorSettings();

    @Override
    public void readData(JsonObject json) {
        if (json.has("generator")) {
            this.genSettings.readData(JsonUtil.getAsObject(json, "generator"));
        }
        if (json.has("biomedata")) {
            this.biomeSettings.readData(JsonUtil.getAsObject(json, "biomedata"));
        }
    }

    @Override
    public void writeData(JsonObject json) {
        JsonObject generator = new JsonObject();
        this.genSettings.writeData(generator);
        if (!generator.entrySet().isEmpty()) {
            json.add("generator", (JsonElement)generator);
        }
        JsonObject biomes = new JsonObject();
        this.biomeSettings.writeData(biomes);
        if (!biomes.entrySet().isEmpty()) {
            json.add("biomedata", (JsonElement)biomes);
        }
    }

    @Override
    public WorldSettings copy() {
        WorldSettings copy = new WorldSettings();
        copy.biomeSettings = this.biomeSettings.copy();
        copy.genSettings = this.genSettings.copy();
        return copy;
    }

    public static WorldSettings loadWorldSettings(World world) {
        WorldInfo worldInfo = world.func_72912_H();
        String generatorSettings = worldInfo.func_82571_y();
        if (generatorSettings.isEmpty()) {
            DefaultWorldSettings settings = new DefaultWorldSettings();
            settings.applyDefaultModuleStack();
            return settings;
        }
        WorldSettings settings = new WorldSettings();
        try {
            settings.readFromJson(generatorSettings);
        }
        catch (Exception e) {
            return new DefaultWorldSettings();
        }
        return settings;
    }

    private static void setGeneratorOptions(World world, WorldInfo worldInfo, WorldSettings settings) {
        if (!world.field_72995_K) {
            RWG.logger.info("Setting empty generatorOptions to current defaults");
            RWG.logger.info(worldInfo.getClass());
            try {
                ReflectionHelper.setPrivateValue(WorldInfo.class, (Object)worldInfo, (Object)settings.writeToJson(), (String[])new String[]{"g", "field_82576_c", "generatorOptions"});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

