/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.noise;

import java.util.Random;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OpenSimplexNoise;

public class OctaveNoise
extends Noise {
    protected OpenSimplexNoise generator;
    protected double scale;
    protected int octaves;
    protected double lacunarity;
    protected double gain;
    protected double offset = 0.0;

    public OctaveNoise(Random rand, double scale, int octaves, double lacunarity, double gain) {
        this.generator = new OpenSimplexNoise(rand.nextLong());
        this.scale = scale;
        this.octaves = octaves;
        this.lacunarity = lacunarity;
        this.gain = gain;
    }

    public OctaveNoise(Random rand, double scale, int octaves) {
        this(rand, scale, octaves, 2.0, 0.5);
    }

    @Override
    public double getValue(int x, int z) {
        double sum = 0.0;
        double size = 1.0 / this.scale;
        double amp = 1.0;
        for (int i = 0; i < this.octaves; ++i) {
            double n = this.generator.eval((double)x * size, (double)z * size, this.offset + 0.5 + (double)i * 31.0);
            sum += n * amp;
            size *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }
}

