/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.noise;

import java.util.Random;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OctaveNoise;
import kenijey.rwg.noise.OpenSimplexNoise;

public class JordanTurbulence
extends Noise {
    protected OpenSimplexNoise generator;
    protected double scale;
    protected OctaveNoise distortion;
    protected int octaves;
    protected double lacunarity;
    protected double gain1;
    protected double gain;
    protected double warp0;
    protected double warp;
    protected double damp0;
    protected double damp;
    protected double damp_scale;
    protected double distortion_magnitude;
    protected int distortion_octaves;
    protected double distortion_scale;
    protected double distortion_gain;

    public JordanTurbulence(Random rand, double scale, int octaves, double lacunarity, double gain1, double gain, double warp0, double warp, double damp0, double damp, double damp_scale, int distortion_octaves, double distortion_scale, double distortion_magnitude, double distortion_gain) {
        this.generator = new OpenSimplexNoise(rand.nextLong());
        this.scale = scale;
        this.octaves = octaves;
        this.lacunarity = lacunarity;
        this.gain1 = gain1;
        this.gain = gain;
        this.warp0 = warp0;
        this.warp = warp;
        this.damp0 = damp0;
        this.damp = damp;
        this.damp_scale = damp_scale;
        this.distortion_octaves = distortion_octaves;
        this.distortion_scale = distortion_scale;
        this.distortion_magnitude = distortion_magnitude;
        this.distortion_gain = distortion_gain;
        this.distortion = new OctaveNoise(rand, this.scale / distortion_scale, distortion_octaves, lacunarity, distortion_gain);
    }

    @Override
    public double getValue(int x, int z) {
        this.distortion.offset = 0.0;
        double dx = (double)x + (this.distortion.getValue(x, z) * 0.5 + 0.5) * this.scale * this.distortion_magnitude;
        this.distortion.offset = 688889.0;
        double dz = (double)z + (this.distortion.getValue(x, z) * 0.5 + 0.5) * this.scale * this.distortion_magnitude;
        return this.generateRaw(dx, dz);
    }

    protected double generateRaw(double x, double z) {
        double xs = x / this.scale;
        double zs = z / this.scale;
        OpenSimplexNoise.PointData3D n = this.generator.evalDeriv(xs, zs, 0.5);
        double dfactor = 2.0;
        double n2 = n.value * n.value;
        double n2x = n.ddx * n.value;
        double n2z = n.ddy * n.value;
        double sum = n2;
        double dsum_warp_x = this.warp0 * n2x * dfactor;
        double dsum_warp_z = this.warp0 * n2z * dfactor;
        double dsum_damp_x = this.damp0 * n2x;
        double dsum_damp_z = this.damp0 * n2z;
        double amp = this.gain1;
        double freq = this.lacunarity;
        double damped_amp = amp * this.gain;
        for (int i = 1; i < this.octaves; ++i) {
            n = this.generator.evalDeriv(xs * freq + dsum_warp_x, zs * freq + dsum_warp_z, (double)(i * 10) + 0.5);
            n2 = n.value * n.value * 1.5 + 0.1;
            n2x = n.ddx * n.value;
            n2z = n.ddy * n.value;
            sum += n2 * damped_amp;
            dsum_warp_x += this.warp * n2x * dfactor;
            dsum_warp_z += this.warp * n2z * dfactor;
            freq *= this.lacunarity;
            damped_amp = (amp *= this.gain) * (1.0 - this.damp_scale / (1.0 + ((dsum_damp_x += this.damp * n2x) * dsum_damp_x + (dsum_damp_z += this.damp * n2z) * dsum_damp_z)));
        }
        return sum;
    }
}

