/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.noise;

import java.util.Random;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OpenSimplexNoise;
import kenijey.rwg.util.MathUtil;

public class DuneNoise
extends Noise {
    protected OpenSimplexNoise generator;
    protected double scale;
    protected double mixscale;

    public DuneNoise(Random rand, double scale, double mixscale) {
        this.generator = new OpenSimplexNoise(rand.nextLong());
        this.scale = scale;
        this.mixscale = mixscale;
    }

    @Override
    public double getValue(int x, int z) {
        double output = 0.0;
        double dscale = 4.0 / this.scale;
        double distortion = this.generator.eval((double)x * dscale, (double)z * dscale, 73533.5) * 0.2;
        double dx = ((double)x * 2.0 + (double)z * 0.6) / this.scale;
        double dz = ((double)z * 0.8 - (double)x * 0.4) / this.scale;
        double dune1 = (1.0 - Math.abs(this.generator.eval(dx, dz, 0.5 + distortion))) * 2.0 - 1.0;
        double dune2 = (1.0 - Math.abs(this.generator.eval(dx, dz, 72039.5 + distortion))) * 2.0 - 1.0;
        double bscale = 0.4 / this.scale;
        double mdune1 = dune1 * (0.2 + 0.8 * this.generator.eval((double)x * bscale * 1.5, (double)z * bscale, 773.5));
        double mdune2 = dune2 * (0.2 + 0.8 * this.generator.eval((double)x * bscale, (double)z * bscale * 0.8, 9482542.5));
        return output += MathUtil.polymax(mdune1, mdune2, this.mixscale);
    }
}

