/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.generator.structure;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import kenijey.rwg.generator.ChunkProviderBasic;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.WoodlandMansionPieces;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class WoodlandMansionRWG
extends MapGenStructure {
    private final int featureSpacing = 80;
    private final int minFeatureSeparation = 20;
    public static final List<Biome> ALLOWED_BIOMES = Arrays.asList(Biomes.field_150585_R, Biomes.field_185430_ab);
    private final ChunkProviderBasic provider;

    public WoodlandMansionRWG(ChunkProviderBasic provider) {
        this.provider = provider;
    }

    public String func_143025_a() {
        return "Mansion";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            i = chunkX - 79;
        }
        if (chunkZ < 0) {
            j = chunkZ - 79;
        }
        int k = i / 80;
        int l = j / 80;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387319);
        k *= 80;
        l *= 80;
        return chunkX == (k += (random.nextInt(60) + random.nextInt(60)) / 2) && chunkZ == (l += (random.nextInt(60) + random.nextInt(60)) / 2) && (flag = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 32, ALLOWED_BIOMES));
    }

    @Nullable
    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && biomeprovider.func_190943_d() != Biomes.field_150585_R ? null : WoodlandMansionRWG.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)80, (int)20, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.provider, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private boolean isValid;

        public Start() {
        }

        public Start(World world, ChunkProviderBasic provider, Random rand, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.create(world, provider, rand, chunkX, chunkZ);
        }

        private void create(World world, ChunkProviderBasic provider, Random rand, int chunkX, int chunkZ) {
            Rotation rotation = Rotation.values()[rand.nextInt(Rotation.values().length)];
            ChunkPrimer chunkprimer = new ChunkPrimer();
            provider.fillChunk(chunkX, chunkZ, chunkprimer);
            int offsetX = 5;
            int offsetZ = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                offsetX = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                offsetX = -5;
                offsetZ = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                offsetZ = -5;
            }
            int tl = chunkprimer.func_186138_a(7, 7);
            int bl = chunkprimer.func_186138_a(7, 7 + offsetZ);
            int tr = chunkprimer.func_186138_a(7 + offsetX, 7);
            int br = chunkprimer.func_186138_a(7 + offsetX, 7 + offsetZ);
            int minheight = Math.min(Math.min(tl, bl), Math.min(tr, br));
            if (minheight < 60) {
                this.isValid = false;
            } else {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, minheight + 1, chunkZ * 16 + 8);
                LinkedList list = Lists.newLinkedList();
                WoodlandMansionPieces.func_191152_a((TemplateManager)world.func_72860_G().func_186340_h(), (BlockPos)blockpos, (Rotation)rotation, (List)list, (Random)rand);
                this.field_75075_a.addAll(list);
                this.func_75072_c();
                this.isValid = true;
            }
        }

        public void func_75068_a(World worldIn, Random rand, StructureBoundingBox structurebb) {
            super.func_75068_a(worldIn, rand, structurebb);
            int y = this.field_75074_b.field_78895_b;
            for (int x = structurebb.field_78897_a; x <= structurebb.field_78893_d; ++x) {
                for (int z = structurebb.field_78896_c; z <= structurebb.field_78892_f; ++z) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(x, y, z);
                    if (worldIn.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructureComponent structurecomponent : this.field_75075_a) {
                        if (!structurecomponent.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int iy = y - 1; iy > 1 && (worldIn.func_175623_d(blockpos1 = new BlockPos(x, iy, z)) || worldIn.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --iy) {
                        worldIn.func_180501_a(blockpos1, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
        }

        public boolean func_75069_d() {
            return this.isValid;
        }
    }
}

