/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.generator.biome;

import com.google.gson.JsonObject;
import java.util.Map;
import kenijey.rwg.util.JsonUtil;
import kenijey.rwg.util.MathUtil;

public abstract class BiomeModParameter<T> {
    public final T defaultValue;

    public BiomeModParameter(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public abstract void writeToJson(JsonObject var1, String var2, Object var3);

    public abstract T readFromJson(JsonObject var1, String var2);

    public T limitInput(T input) {
        return input;
    }

    public static <U> U getManual(String name, Map<String, Object> args, U fallback) {
        if (args != null && args.containsKey(name)) {
            return (U)args.get(name);
        }
        return fallback;
    }

    public static <U> U get(String name, Map<String, Object> args, BiomeModParameter<U> parameter) {
        return parameter.limitInput(BiomeModParameter.getManual(name, args, parameter.defaultValue));
    }

    public static <U> U get(String name, Map<String, Object> args, Map<String, BiomeModParameter> parameters) {
        BiomeModParameter parameter = parameters.get(name);
        return BiomeModParameter.get(name, args, parameter);
    }

    public static class BooleanParameter
    extends BiomeModParameter<Boolean> {
        public final boolean defaultValue;

        public BooleanParameter(boolean value) {
            super(value);
            this.defaultValue = value;
        }

        @Override
        public void writeToJson(JsonObject json, String tag, Object value) {
            json.addProperty(tag, Boolean.valueOf((Boolean)value));
        }

        @Override
        public Boolean readFromJson(JsonObject json, String tag) {
            return JsonUtil.get(json, tag, this.defaultValue);
        }
    }

    public static class StringParameter
    extends BiomeModParameter<String> {
        public StringParameter(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public void writeToJson(JsonObject json, String tag, Object value) {
            json.addProperty(tag, value.toString());
        }

        @Override
        public String readFromJson(JsonObject json, String tag) {
            return (String)JsonUtil.get(json, tag, this.defaultValue);
        }
    }

    public static class DoubleParameter
    extends BiomeModParameter<Double> {
        public final double lowerLimit;
        public final double upperLimit;

        public DoubleParameter(double value, double lowerLimit, double upperLimit) {
            super(value);
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        public DoubleParameter(double defaultValue) {
            this(defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
        }

        @Override
        public void writeToJson(JsonObject json, String tag, Object value) {
            json.addProperty(tag, (Number)MathUtil.clamp((Double)value, this.lowerLimit, this.upperLimit));
        }

        @Override
        public Double readFromJson(JsonObject json, String tag) {
            return MathUtil.clamp((Double)JsonUtil.get(json, tag, this.defaultValue), this.lowerLimit, this.upperLimit);
        }

        @Override
        public Double limitInput(Double input) {
            return MathUtil.clamp(input, this.lowerLimit, this.upperLimit);
        }
    }

    public static class VariantParameter
    extends IntParameter {
        public VariantParameter(int count) {
            super(0, 0, Math.max(count - 1, 0));
        }
    }

    public static class IntParameter
    extends BiomeModParameter<Integer> {
        public final int lowerLimit;
        public final int upperLimit;

        public IntParameter(int defaultValue, int lowerLimit, int upperLimit) {
            super(defaultValue);
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        public IntParameter(int value) {
            this(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public void writeToJson(JsonObject json, String tag, Object value) {
            json.addProperty(tag, (Number)MathUtil.clamp((Integer)value, this.lowerLimit, this.upperLimit));
        }

        @Override
        public Integer readFromJson(JsonObject json, String tag) {
            return MathUtil.clamp((Integer)JsonUtil.get(json, tag, this.defaultValue), this.lowerLimit, this.upperLimit);
        }

        @Override
        public Integer limitInput(Integer input) {
            return MathUtil.clamp(input, this.lowerLimit, this.upperLimit);
        }
    }
}

