/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.generator;

import java.util.HashMap;
import kenijey.rwg.generator.BiomeProviderRWG;
import kenijey.rwg.generator.ChunkProviderBasic;
import kenijey.rwg.generator.biome.BiomeRegistry;
import kenijey.rwg.settings.ChunkGeneratorSettings;
import kenijey.rwg.settings.WorldSettings;
import kenijey.rwg.util.GeneralUtil;
import kenijey.rwg.util.Kernel;
import kenijey.rwg.util.MathUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class ChunkProviderRWG
extends ChunkProviderBasic {
    public static final int BLEND_RADIUS = 5;
    public static final Kernel BLEND_KERNEL = new Kernel(5, (x, z) -> {
        double dist = Math.sqrt(x * x + z * z);
        if (dist > 5.0) {
            return 0.0;
        }
        return MathUtil.smoothstep(dist / 5.0) * 0.5 + 0.5;
    });
    protected ChunkGeneratorSettings settings;

    public ChunkProviderRWG(World world) {
        super(world);
        this.settings = WorldSettings.loadWorldSettings((World)world).genSettings;
    }

    @Override
    public float getFloatTemperature(Biome biome, BlockPos pos) {
        if (pos.func_177956_o() < 64) {
            return super.getFloatTemperature(biome, pos);
        }
        return super.getFloatTemperature(biome, pos) + (float)(pos.func_177956_o() - 64) * 0.0011000001f;
    }

    @Override
    public void fillChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        BiomeProviderRWG provider = GeneralUtil.getRWGBiomeProvider(this.world);
        if (provider == null) {
            super.fillChunk(chunkX, chunkZ, primer);
            return;
        }
        IBlockState landblock = Blocks.field_150348_b.func_176223_P();
        IBlockState seablock = Blocks.field_150355_j.func_176223_P();
        int water = 63;
        for (int ix = 0; ix < 16; ++ix) {
            for (int iz = 0; iz < 16; ++iz) {
                int x = chunkX * 16 + ix;
                int z = chunkZ * 16 + iz;
                double height = provider.noise.getHeight(x, z);
                height = this.getBiomeNoiseBlend(x, z, height, provider);
                int heightInt = (int)Math.floor(height * 255.0);
                int limit = Math.max(water, heightInt);
                for (int iy = 0; iy < limit; ++iy) {
                    if (iy <= heightInt) {
                        primer.func_177855_a(ix, iy, iz, landblock);
                        continue;
                    }
                    primer.func_177855_a(ix, iy, iz, seablock);
                }
            }
        }
    }

    public double getBiomeNoiseBlend(int x, int z, double height, BiomeProviderRWG provider) {
        double smoothing;
        BiomeRegistry.HeightModRegistryEntry heightmod;
        Biome mainBiome = provider.getBestBiomeCached(x, z);
        double noise = 0.0;
        HashMap<Biome, Double> heights = new HashMap<Biome, Double>();
        for (int ix = -5; ix <= 5; ++ix) {
            for (int iz = -5; iz <= 5; ++iz) {
                double modheight;
                double k = BLEND_KERNEL.getValue(ix, iz);
                if (!(k > 0.0)) continue;
                Biome biome = provider.getBestBiomeCached(x + ix, z + iz);
                if (heights.containsKey(biome)) {
                    noise += (Double)heights.get(biome) * k;
                    continue;
                }
                heightmod = provider.biomeRegistry.getHeightModifier(biome);
                if (heightmod == null) {
                    modheight = height;
                } else {
                    smoothing = 1.0;
                    if (mainBiome != biome) {
                        smoothing = provider.biomeRegistry.getSmoothingFactor(biome);
                    }
                    modheight = height * (1.0 - smoothing) + heightmod.modifier.getModifiedHeight(x + provider.noise.heightModOffset.x, z + provider.noise.heightModOffset.z, height, heightmod.arguments) * smoothing;
                }
                noise += modheight * k;
                heights.put(biome, modheight);
            }
        }
        heightmod = provider.biomeRegistry.getHeightModifier(mainBiome);
        smoothing = provider.biomeRegistry.getSmoothingFactor(mainBiome);
        double baseheight = height;
        if (heightmod != null) {
            baseheight = heightmod.modifier.getModifiedHeight(x + provider.noise.heightModOffset.x, z + provider.noise.heightModOffset.z, height, heightmod.arguments);
        }
        return baseheight + (noise - baseheight) * smoothing;
    }
}

