/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.generator;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import kenijey.rwg.generator.CoreNoise;
import kenijey.rwg.generator.biome.BiomeBlobs;
import kenijey.rwg.generator.biome.BiomeRegistry;
import kenijey.rwg.settings.BiomeSettings;
import kenijey.rwg.settings.WorldSettings;
import kenijey.rwg.util.MathUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.IntCache;

public class BiomeProviderRWG
extends BiomeProvider {
    public CoreNoise noise;
    protected final BiomeCache field_76942_f;
    protected final List<Biome> field_76943_g;
    public static final float TEMP_CORRECTION_PER_HEIGHT = 0.0011000001f;
    protected World world;
    protected BiomeSettings field_190945_a;
    protected Random fuzz;
    public BiomeRegistry biomeRegistry;

    public BiomeProviderRWG(World world) {
        this.world = world;
        this.field_190945_a = WorldSettings.loadWorldSettings((World)world).biomeSettings;
        this.noise = new CoreNoise(world.func_72905_C());
        this.fuzz = new Random();
        this.field_76942_f = new BiomeCache((BiomeProvider)this);
        this.field_76943_g = Lists.newArrayList((Iterable)allowedBiomes);
        this.biomeRegistry = new BiomeRegistry();
        this.biomeRegistry.populate(this.field_190945_a);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.field_76942_f.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        for (int ix = 0; ix < width; ++ix) {
            for (int iz = 0; iz < height; ++iz) {
                int bx = x + ix;
                int bz = z + iz;
                biomes[iz * width + ix] = this.getBestBiome(bx, bz);
            }
        }
        return biomes;
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] abiome = this.field_76942_f.func_76839_e(x, z);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        for (int ix = 0; ix < width; ++ix) {
            for (int iz = 0; iz < length; ++iz) {
                int bx = x + ix;
                int bz = z + iz;
                listToReuse[iz * width + ix] = this.getBestBiomeCached(bx, bz);
            }
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int xmin = x - (radius >> 2);
        int zmin = z - (radius >> 2);
        int xmax = x + (radius >> 2);
        int zmax = z + (radius >> 2);
        int xdiff = xmax - xmin + 1;
        int zdiff = zmax - zmin + 1;
        Biome[] biomes = this.func_76931_a(null, xmin, zmin, xdiff, zdiff, true);
        try {
            for (int index = 0; index < xdiff * zdiff; ++index) {
                if (allowed.contains(biomes[index])) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", allowed);
            throw new ReportedException(crashreport);
        }
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int xmin = x - (range >> 2);
        int zmin = z - (range >> 2);
        int xmax = x + (range >> 2);
        int zmax = z + (range >> 2);
        int xdiff = xmax - xmin + 1;
        int zdiff = zmax - zmin + 1;
        Biome[] genbiomes = this.func_76931_a(null, xmin, zmin, xdiff, zdiff, true);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int index = 0; index < xdiff * zdiff; ++index) {
            int i2 = xmin + index % xdiff << 2;
            int j2 = zmin + index / xdiff << 2;
            Biome biome = genbiomes[index];
            if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public float func_76939_a(float temp, int height) {
        if (height < 64) {
            return temp;
        }
        return temp + (float)(height - 64) * 0.0011000001f;
    }

    public Biome getBestBiomeCached(int x, int z) {
        Biome biome;
        CoreNoise.NoiseEntry entry = this.noise.getEntry(x, z);
        if (entry.biome != null) {
            return entry.biome;
        }
        entry.biome = biome = this.getBestBiome(x, z);
        return biome;
    }

    public Biome getBestBiome(int x, int z) {
        double weight = Double.MIN_VALUE;
        BiomeRegistry.BiomeGroup bestGroup = null;
        Map<BiomeRegistry.BiomeGroup, Double> weights = this.getBiomeWeights(x, z, this.noise);
        for (BiomeRegistry.BiomeGroup b : weights.keySet()) {
            double w = weights.get(b);
            if (!(w > weight)) continue;
            bestGroup = b;
            weight = w;
        }
        if (bestGroup == null) {
            return Biomes.field_180279_ad;
        }
        return this.getSubBiomeForPosition(x, z, bestGroup);
    }

    public Biome getSubBiomeForPosition(int x, int z, BiomeRegistry.BiomeGroup group) {
        BiomeBlobs.BlobEntry blob = this.noise.blobs.getValue(x + group.offsetx, z + group.offsetz, 8 + group.blobSizeModifier, 7 + group.blobSizeModifier + group.subBlobSizeModfier);
        Biome biome = group.getBiome(blob.biome);
        biome = this.biomeRegistry.getHillBiome(biome, this.noise, x, z);
        biome = this.biomeRegistry.getSubBiome(biome, blob.subbiome);
        return biome;
    }

    public Map<BiomeRegistry.BiomeGroup, Double> getBiomeWeights(int x, int z, CoreNoise corenoise) {
        HashMap<BiomeRegistry.BiomeGroup, Double> weights = new HashMap<BiomeRegistry.BiomeGroup, Double>();
        double height = corenoise.getHeight(x, z);
        double temp = corenoise.getTemperature(x, z) + MathUtil.getFuzz(x, z, 345) * 0.0234375;
        temp = MathUtil.spreadRange(temp, 0.4, 1.5, -0.15, -0.05, 1.0);
        double moisture = corenoise.getMoisture(x, z) + MathUtil.getFuzz(x, z, 103) * 0.015625;
        moisture = MathUtil.spreadRange(moisture, 0.4, 1.5, 0.07);
        double inland = corenoise.getInland(x, z);
        double swamp = corenoise.getSwamp(x, z);
        double roughness = corenoise.getRoughness(x, z);
        double fertility = this.getFertility(temp, moisture, height);
        BiomeRegistry.EnumBiomeCategory category = BiomeRegistry.EnumBiomeCategory.LAND;
        double heightfuzz = MathUtil.getFuzz(x, z, 345) / 256.0;
        if (height - heightfuzz * 0.5 < 0.2) {
            category = BiomeRegistry.EnumBiomeCategory.OCEAN;
        } else if (height - heightfuzz * 0.5 < 0.30196078431372547 && (height >= 0.25882352941176473 && swamp > MathUtil.clamp(roughness * 1.5 + 0.25 + heightfuzz * 2.5, 0.0, 0.95) || height < 0.25882352941176473 && swamp > 0.0)) {
            category = BiomeRegistry.EnumBiomeCategory.SWAMP;
        } else if (height < 0.25882352941176473) {
            category = height - heightfuzz * 0.5 < 0.22745098039215686 ? BiomeRegistry.EnumBiomeCategory.OCEAN : BiomeRegistry.EnumBiomeCategory.BEACH;
        }
        Map<String, BiomeRegistry.BiomeGroup> biomeset = this.biomeRegistry.biomeGroups.get((Object)category);
        if (!biomeset.isEmpty()) {
            for (BiomeRegistry.BiomeGroup b : biomeset.values()) {
                if (b == null || b.biomes.isEmpty() || height + heightfuzz > b.maxHeight || height + heightfuzz < b.minHeight) continue;
                double bh = b.height;
                double bt = b.temperature;
                double bm = b.moisture;
                bt = MathUtil.spreadRange(bt, 0.4, 1.3, -0.3, -0.075, 2.0) * 0.667;
                bm = MathUtil.spreadRange(bm, 0.4, 1.2, 0.07);
                double bf = this.getFertility(bt, bm, bh);
                double dt = 1.0 - Math.abs(temp - bt);
                double dm = 1.0 - Math.abs(moisture - bm);
                double df = 1.0 - Math.abs(fertility - bf);
                double suitability = df * 0.5 + dt + dm;
                weights.put(b, suitability);
            }
        }
        if (weights.isEmpty()) {
            weights.put(category.fallback, 1.0);
        }
        return weights;
    }

    private double getFertility(double temp, double moisture, double height) {
        return Math.max(0.0, moisture * 1.15 - Math.abs(temp - 0.65) - (height - 0.5));
    }
}

