/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.compat;

import kenijey.rwg.RWG;
import kenijey.rwg.settings.BiomeSettings;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class BiomeModule
implements Comparable<BiomeModule> {
    public BiomeSettings settings;
    public String name;
    public String owner;
    public boolean active = false;
    public final boolean startsEnabled;

    public BiomeModule(String name, String owner, BiomeSettings settings, boolean startsEnabled) {
        this.name = name;
        this.owner = owner;
        this.settings = settings;
        this.startsEnabled = startsEnabled;
        this.active = startsEnabled;
    }

    public static void fromIMC(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            RWG.logger.warn("Invalid IMC sent by {} - biomeModule expects NBT", (Object)message.getSender());
            return;
        }
        NBTTagCompound tag = message.getNBTValue();
        if (!tag.func_74764_b("name") || tag.func_74779_i("name").isEmpty()) {
            RWG.logger.warn("Invalid IMC sent by {} - biomeModule requires a name in the 'name' tag", (Object)message.getSender());
            return;
        }
        if (!tag.func_74764_b("json") || tag.func_74779_i("json").isEmpty()) {
            RWG.logger.warn("Invalid IMC sent by {} - biomeModule requires biome settings data in the 'json' tag", (Object)message.getSender());
            return;
        }
        BiomeSettings settings = new BiomeSettings();
        try {
            settings.readFromJson(tag.func_74779_i("json"));
        }
        catch (Exception e) {
            RWG.logger.warn("Invalid IMC sent by {} - biomeModule received invalid biome json data", (Object)message.getSender());
            return;
        }
        BiomeModule module = new BiomeModule(tag.func_74779_i("name"), message.getSender(), settings, tag.func_74767_n("enabled"));
        RWG.globalRegistry.biomeModules.add(module);
    }

    @Override
    public int compareTo(BiomeModule o) {
        return this.settings.compareTo(o.settings);
    }
}

