/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.biome.heightmods;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import kenijey.rwg.biome.heightmods.ParamHeightMod;
import kenijey.rwg.generator.biome.BiomeModParameter;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OctaveNoise;
import kenijey.rwg.noise.RidgeNoise;
import kenijey.rwg.noise.TailoredNoise;
import kenijey.rwg.util.MathUtil;

public class HeightModPlateaus
extends ParamHeightMod {
    protected Noise plateaunoise;
    protected Noise roughness;
    protected Noise rifts;

    public HeightModPlateaus() {
        this.parameters.put("stepsize", new BiomeModParameter.IntParameter(16, 1, 255));
        this.parameters.put("magnitude", new BiomeModParameter.DoubleParameter(0.045, 0.0, 1.0));
        this.parameters.put("riftdepth", new BiomeModParameter.DoubleParameter(0.05, 0.0, 1.0));
        Random rand = new Random(37813873749245L);
        this.plateaunoise = new TailoredNoise(rand, 200.0, 0.5, 50.0, 0.2, 20.0, 0.1, 8.0, 0.01);
        this.roughness = new OctaveNoise(rand, 30.0, 3);
        this.rifts = new RidgeNoise(rand, 150.0, 4);
    }

    @Override
    public double getModifiedHeight(int x, int z, double height, @Nullable Map<String, Object> args) {
        int stepsize = (Integer)this.parameter("stepsize", args);
        double magnitude = (Double)this.parameter("magnitude", args);
        double riftdepth = (Double)this.parameter("riftdepth", args);
        double plateau = this.plateaunoise.getValue(x, z);
        double rough = this.roughness.getValue(x, z);
        double rift = this.rifts.getValue(x, z);
        double n = height + (plateau + 0.6) * 0.65 * magnitude;
        int halfstep = stepsize / 2;
        int steps = Math.floorDiv(255, stepsize);
        double sharp = n;
        for (int i = 0; i < steps; ++i) {
            int h = i * stepsize + halfstep + (int)Math.round(rough * 1.5);
            sharp = MathUtil.plateau(sharp, h - halfstep, h, h + halfstep, 5.0 - rough, false);
        }
        double mix = MathUtil.smoothstep((rough + 0.6) * 1.2);
        n = mix * sharp + (1.0 - mix) * n;
        double r = rift * rift * rift;
        r = Math.max(0.0, r - 0.8);
        n -= r * riftdepth;
        return MathUtil.polymax(n += rough * 0.01, height, 0.5);
    }
}

