/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.biome.heightmods;

import java.util.Map;
import javax.annotation.Nullable;
import kenijey.rwg.biome.heightmods.ParamHeightMod;
import kenijey.rwg.generator.biome.BiomeModParameter;
import kenijey.rwg.util.MathUtil;

public class HeightModOffset
extends ParamHeightMod {
    public HeightModOffset() {
        this.parameters.put("height", new BiomeModParameter.IntParameter(0, 0, 255));
        this.parameters.put("tapered", new BiomeModParameter.BooleanParameter(false));
        this.parameters.put("taperstart", new BiomeModParameter.IntParameter(0, 0, 255));
        this.parameters.put("taperend", new BiomeModParameter.IntParameter(0, 0, 255));
        this.parameters.put("taperheight", new BiomeModParameter.IntParameter(0, 0, 255));
    }

    @Override
    public double getModifiedHeight(int x, int z, double height, @Nullable Map<String, Object> args) {
        int offset = BiomeModParameter.getManual("height", args, 0);
        boolean tapered = BiomeModParameter.getManual("tapered", args, false);
        if (tapered) {
            int taperstart = BiomeModParameter.getManual("taperstart", args, 0);
            int taperend = BiomeModParameter.getManual("taperend", args, 0);
            int taperheight = BiomeModParameter.getManual("taperheight", args, 0);
            if (taperstart == taperend) {
                return height + (double)offset / 255.0;
            }
            double dtaperstart = (double)taperstart / 255.0;
            double dtaperend = (double)taperend / 255.0;
            double dtaperheight = (double)taperheight / 255.0;
            double doffset = (double)offset / 255.0;
            if (height < dtaperstart) {
                return height + doffset;
            }
            if (height > dtaperend) {
                return height + dtaperheight;
            }
            double fraction = MathUtil.smoothstep((height - dtaperstart) / (dtaperend - dtaperstart));
            return height + doffset * (1.0 - fraction) + dtaperheight * fraction;
        }
        return height + (double)offset / 255.0;
    }
}

