/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.biome.heightmods;

import java.util.Map;
import java.util.Random;
import kenijey.rwg.biome.heightmods.ParamHeightMod;
import kenijey.rwg.generator.biome.BiomeModParameter;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OctaveNoise;
import kenijey.rwg.util.MathUtil;

public class HeightModIsland
extends ParamHeightMod {
    protected Noise landNoise;
    protected Noise cliffNoise;
    protected Noise hillNoise;

    public HeightModIsland() {
        this.parameters.put("heightoffset", new BiomeModParameter.IntParameter(0, -255, 255));
        this.parameters.put("hilliness", new BiomeModParameter.DoubleParameter(1.0, 0.0, 5.0));
        Random rand = new Random(2893742398423L);
        this.landNoise = new OctaveNoise(rand, 50.0, 4);
        this.hillNoise = new OctaveNoise(rand, 100.0, 4);
        this.cliffNoise = new OctaveNoise(rand, 50.0, 3);
    }

    @Override
    public double getModifiedHeight(int x, int z, double height, Map<String, Object> args) {
        int heightoffset = (Integer)this.parameter("heightoffset", args);
        double hilliness = (Double)this.parameter("hilliness", args);
        double sealevel = 0.25 + (double)heightoffset / 255.0;
        double land = this.landNoise.getValue(x, z);
        double hill = this.hillNoise.getValue(x, z);
        double cliff = this.cliffNoise.getValue(x, z);
        double value = sealevel + (land * 4.0 + 0.5) / 255.0;
        double hillmask = MathUtil.clamp((land + 0.5) * 1.25, 0.0196078431372549, 1.0);
        value += Math.max(0.0, hill * hilliness * 0.1 * MathUtil.smoothstep(hillmask));
        double th = 0.4;
        if (cliff >= th) {
            double fraction = MathUtil.smoothstep((cliff - th) / (1.0 - th));
            int seaint = (int)Math.floor(sealevel * 255.0);
            int cliff1 = seaint + 15;
            int cliff2 = seaint + 50;
            int range = 15;
            double cliffheight = MathUtil.plateau(value, cliff1 - range, cliff1, cliff1 + range, 4.0, false);
            cliffheight = MathUtil.plateau(cliffheight, cliff2 - range, cliff2, cliff2 + range, 4.0, false);
            value = value * (1.0 - fraction) + cliffheight * fraction;
        }
        return value;
    }
}

