/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg;

import kenijey.rwg.RWG;
import kenijey.rwg.biome.BiomeGravelBeach;
import kenijey.rwg.biome.BiomeScrubland;
import kenijey.rwg.biome.BiomeShrubland;
import kenijey.rwg.biome.BiomeSnowyGravelBeach;
import kenijey.rwg.biome.BiomeTropicalShrubland;
import kenijey.rwg.biome.BiomeTundra;
import kenijey.rwg.biome.BiomeWoodland;
import kenijey.rwg.biome.heightmods.HeightModDunes;
import kenijey.rwg.biome.heightmods.HeightModIsland;
import kenijey.rwg.biome.heightmods.HeightModMesa;
import kenijey.rwg.biome.heightmods.HeightModOffset;
import kenijey.rwg.biome.heightmods.HeightModPlateaus;
import kenijey.rwg.generator.biome.IBiomeHeightModifier;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class RWGBiomes {
    public static Biome SHRUBLAND;
    public static Biome WOODLAND;
    public static Biome TROPICAL_SHRUBLAND;
    public static Biome SCRUBLAND;
    public static Biome TUNDRA;
    public static Biome GRAVEL_BEACH;
    public static Biome GRAVEL_BEACH_SNOWY;
    private static IForgeRegistry<Biome> registry;

    public static void init(IForgeRegistry<Biome> registry) {
        HeightModifiers.init();
        RWGBiomes.registry = registry;
        SHRUBLAND = RWGBiomes.register("shrubland", new BiomeShrubland(), true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        WOODLAND = RWGBiomes.register("woodland", new BiomeWoodland(), false, BiomeDictionary.Type.FOREST);
        TROPICAL_SHRUBLAND = RWGBiomes.register("tropical_shrubland", new BiomeTropicalShrubland(), false, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SAVANNA);
        SCRUBLAND = RWGBiomes.register("scrubland", new BiomeScrubland(), true, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA);
        TUNDRA = RWGBiomes.register("steppe", new BiomeTundra(), true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.SPARSE);
        GRAVEL_BEACH = RWGBiomes.register("gravel_beach", new BiomeGravelBeach(), false, BiomeDictionary.Type.COLD, BiomeDictionary.Type.BEACH);
        GRAVEL_BEACH_SNOWY = RWGBiomes.register("snowy_gravel_beach", new BiomeSnowyGravelBeach(), false, BiomeDictionary.Type.COLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SNOWY);
    }

    public static Biome register(String name, Biome biome, boolean villages, BiomeDictionary.Type ... dictionaryTypes) {
        biome.setRegistryName("rwg", name);
        registry.register((IForgeRegistryEntry)biome);
        if (villages) {
            BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
        }
        if (dictionaryTypes.length > 0) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])dictionaryTypes);
        }
        return biome;
    }

    public static abstract class Features {
        public static final WorldGenShrub OAK_SHRUB = new WorldGenShrub(BiomeBlocks.OAK_LOG, BiomeBlocks.OAK_LEAF);
        public static final WorldGenShrub JUNGLE_SHRUB = new WorldGenShrub(BiomeBlocks.JUNGLE_LOG, BiomeBlocks.OAK_LEAF);
        public static final WorldGenShrub TUNDRA_SHRUB = new WorldGenShrub(BiomeBlocks.OAK_LOG, BiomeBlocks.SPRUCE_LEAF);
        public static final WorldGenSavannaTree SAVANNA_TREE = new WorldGenSavannaTree(false);
        public static final WorldGenBlockBlob BOULDER_COBBLE = new WorldGenBlockBlob(Blocks.field_150347_e, 0);
    }

    public static abstract class BiomeBlocks {
        public static final IBlockState OAK_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
        public static final IBlockState OAK_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        public static final IBlockState BIRCH_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
        public static final IBlockState BIRCH_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        public static final IBlockState SPRUCE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE);
        public static final IBlockState SPRUCE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        public static final IBlockState JUNGLE_LOG = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        public static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    }

    public static abstract class HeightModifiers {
        public static IBiomeHeightModifier DUNES;
        public static IBiomeHeightModifier ISLAND;
        public static IBiomeHeightModifier MESA;
        public static IBiomeHeightModifier PLATEAU;
        public static IBiomeHeightModifier OFFSET;

        public static void init() {
            DUNES = RWG.globalRegistry.registerHeightModifier(new HeightModDunes(), "dunes");
            ISLAND = RWG.globalRegistry.registerHeightModifier(new HeightModIsland(), "island");
            MESA = RWG.globalRegistry.registerHeightModifier(new HeightModMesa(), "mesa");
            PLATEAU = RWG.globalRegistry.registerHeightModifier(new HeightModPlateaus(), "plateau");
            OFFSET = RWG.globalRegistry.registerHeightModifier(new HeightModOffset(), "offset");
        }
    }
}

