/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import its_meow.betteranimalsplus.client.model.ModelWolfCape;
import its_meow.betteranimalsplus.common.item.ItemCape;
import its_meow.betteranimalsplus.common.item.ItemWolfCape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWolfCapeBaubles
extends ItemWolfCape
implements IBauble,
IRenderBauble {
    private static final ResourceLocation WOLF_CAPE_SNOWY = new ResourceLocation("betteranimalsplus", "textures/models/armor/wolf_cape_classic_layer_1.png");
    private static final ResourceLocation WOLF_CAPE_TIMBER = new ResourceLocation("betteranimalsplus", "textures/models/armor/wolf_cape_timber_layer_1.png");
    private static final ResourceLocation WOLF_CAPE_BLACK = new ResourceLocation("betteranimalsplus", "textures/models/armor/wolf_cape_black_layer_1.png");
    private static final ResourceLocation WOLF_CAPE_ARCTIC = new ResourceLocation("betteranimalsplus", "textures/models/armor/wolf_cape_arctic_layer_1.png");
    private static final ResourceLocation WOLF_CAPE_BROWN = new ResourceLocation("betteranimalsplus", "textures/models/armor/wolf_cape_brown_layer_1.png");
    private static final ResourceLocation WOLF_CAPE_RED = new ResourceLocation("betteranimalsplus", "textures/models/armor/wolf_cape_red_layer_1.png");

    public ItemWolfCapeBaubles(String variant, Item repairItem) {
        super(variant, repairItem);
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    @Override
    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        if (entity instanceof EntityPlayer) {
            return !(BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)entity)).getStackInSlot(BaubleType.BODY.ordinal()).func_77973_b() instanceof ItemCape);
        }
        return super.isValidArmor(stack, armorType, entity);
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return !(player.func_184582_a(this.slot).func_77973_b() instanceof ItemCape);
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer living, IRenderBauble.RenderType type, float partialTicks) {
        if (type == IRenderBauble.RenderType.BODY) {
            TextureManager texturemanager = Minecraft.func_71410_x().func_175598_ae().field_78724_e;
            if (texturemanager != null) {
                texturemanager.func_110577_a(ItemWolfCapeBaubles.getTexture(this.variant));
            }
            ModelWolfCape model = ModelWolfCape.INSTANCE_BAUBLE;
            this.displays(model, this.slot);
            model.field_78117_n = living.func_70093_af();
            model.field_78093_q = living.func_184218_aH();
            model.field_78091_s = living.func_70631_g_();
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (model.field_78117_n) {
                GlStateManager.func_179137_b((double)0.0, (double)-0.2, (double)0.0);
            }
            GlStateManager.func_179139_a((double)0.12, (double)0.12, (double)0.12);
            IRenderBauble.Helper.translateToChest();
            IRenderBauble.Helper.defaultTransforms();
            model.func_78088_a((Entity)living, living.field_184619_aG, living.field_70721_aZ, living.field_70173_aa, living.field_70126_B, living.field_70125_A, 1.0f);
            GlStateManager.func_179121_F();
        }
    }

    private static ResourceLocation getTexture(String variant) {
        switch (variant) {
            case "classic": {
                return WOLF_CAPE_SNOWY;
            }
            case "timber": {
                return WOLF_CAPE_TIMBER;
            }
            case "black": {
                return WOLF_CAPE_BLACK;
            }
            case "arctic": {
                return WOLF_CAPE_ARCTIC;
            }
            case "brown": {
                return WOLF_CAPE_BROWN;
            }
            case "red": {
                return WOLF_CAPE_RED;
            }
        }
        return WOLF_CAPE_SNOWY;
    }
}

