/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.item;

import its_meow.betteranimalsplus.common.block.BlockAnimalSkull;
import its_meow.betteranimalsplus.common.tileentity.TileEntityHead;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockSkull
extends ItemBlock {
    public final boolean allowFloor;
    public final int typeNum;

    public ItemBlockSkull(Block block, boolean allowFloor, int typeNum) {
        super(block);
        if (block.getRegistryName() != null) {
            this.setRegistryName(block.getRegistryName() + (block.getRegistryName().toString().endsWith("_" + typeNum) ? "" : "_" + typeNum));
        }
        this.allowFloor = allowFloor;
        this.typeNum = typeNum;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150431_aC && block.func_176200_f((IBlockAccess)world, pos)) {
            side = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        return this.canBlockBePlaced(world, block, pos, false, side, null, stack);
    }

    public boolean canBlockBePlaced(World world, Block blockToPlace, BlockPos pos, boolean useBounds, EnumFacing side, Entity entity, ItemStack stack) {
        AxisAlignedBB bb;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        AxisAlignedBB axisAlignedBB = bb = useBounds ? null : state.func_185900_c((IBlockAccess)world, pos);
        if (bb != null && !world.func_72917_a(bb, entity)) {
            return false;
        }
        return block.func_176200_f((IBlockAccess)world, pos) && blockToPlace.func_176196_c(world, pos);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (side == EnumFacing.DOWN || side == EnumFacing.UP && !this.allowFloor) {
            return EnumActionResult.FAIL;
        }
        BlockPos clickedPos = pos.func_177972_a(side);
        IBlockState clickedState = world.func_180495_p(clickedPos);
        if (!clickedState.func_177230_c().func_176200_f((IBlockAccess)world, clickedPos)) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            world.func_180501_a(clickedPos, this.field_150939_a.func_176223_P().func_177226_a((IProperty)BlockAnimalSkull.FACING, (Comparable)side), 3);
            TileEntity tile = world.func_175625_s(clickedPos);
            this.populateTile(stack, side, player, tile);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    protected void populateTile(ItemStack stack, EnumFacing side, EntityPlayer player, TileEntity tile) {
        if (tile instanceof TileEntityHead) {
            TileEntityHead tileSkull = (TileEntityHead)tile;
            float rotation = 0.0f;
            rotation = side == EnumFacing.UP || side == EnumFacing.DOWN ? EnumFacing.func_176733_a((double)player.field_70759_as).func_185119_l() : (float)((int)side.func_185119_l());
            tileSkull.setRotation(rotation);
            tileSkull.setType(this.typeNum);
        }
    }
}

