/*
 * Decompiled with CFR 0.152.
 */
package its_meow.betteranimalsplus.common.entity.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityAIEatGrassCustom
extends EntityAIBase {
    protected static final Predicate<IBlockState> IS_TALL_GRASS = BlockStateMatcher.func_177638_a((Block)Blocks.field_150329_H).func_177637_a((IProperty)BlockTallGrass.field_176497_a, Predicates.equalTo((Object)BlockTallGrass.EnumType.GRASS));
    protected final EntityLiving eater;
    protected final World world;
    protected int eatingGrassTimer;
    protected final int childChance;
    protected final int adultChance;
    protected final Function<EntityLiving, BlockPos> getPosition;

    public EntityAIEatGrassCustom(EntityLiving eater, int childChance, int adultChance) {
        this(eater, childChance, adultChance, e -> new BlockPos(e.field_70165_t, e.field_70163_u, e.field_70161_v));
    }

    public EntityAIEatGrassCustom(EntityLiving eater, int childChance, int adultChance, Function<EntityLiving, BlockPos> getPosition) {
        this.eater = eater;
        this.world = eater.field_70170_p;
        this.childChance = childChance;
        this.adultChance = adultChance;
        this.getPosition = getPosition;
        this.func_75248_a(7);
    }

    public boolean func_75250_a() {
        if (this.eater.func_70681_au().nextInt(this.eater.func_70631_g_() ? this.childChance : this.adultChance) != 0) {
            return false;
        }
        BlockPos blockpos = this.getPosition.apply(this.eater);
        return IS_TALL_GRASS.apply((Object)this.world.func_180495_p(blockpos)) || this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150349_c;
    }

    public void func_75249_e() {
        this.eatingGrassTimer = 40;
        this.world.func_72960_a((Entity)this.eater, (byte)10);
        this.eater.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingGrassTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void func_75246_d() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4) {
            BlockPos blockpos = this.getPosition.apply(this.eater);
            if (IS_TALL_GRASS.apply((Object)this.world.func_180495_p(blockpos))) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)this.eater)) {
                    this.world.func_175655_b(blockpos, false);
                }
                this.eater.func_70615_aA();
            } else {
                BlockPos blockpos1 = blockpos.func_177977_b();
                if (this.world.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150349_c) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.world, (Entity)this.eater)) {
                        this.world.func_175718_b(2001, blockpos1, Block.func_149682_b((Block)Blocks.field_150349_c));
                        this.world.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                    this.eater.func_70615_aA();
                }
            }
        }
    }
}

