/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.blocks;

import com.luxtracon.floralis.Main;
import com.luxtracon.floralis.inits.BlockInit;
import com.luxtracon.floralis.utilities.TileEntityPlantPot;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockPotFlower
extends BlockContainer {
    public static final PropertyEnum<EnumFlowerType> CONTENTS = PropertyEnum.func_177709_a((String)"contents", EnumFlowerType.class);
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    public BlockPotFlower(String name, Material material) {
        super(material);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149647_a(Main.MODTAB);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONTENTS, (Comparable)((Object)EnumFlowerType.EMPTY)));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean canBePotted(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return block == BlockInit.flowerWhite || block == BlockInit.flowerOrange || block == BlockInit.flowerMagenta || block == BlockInit.flowerLightBlue || block == BlockInit.flowerYellow || block == BlockInit.flowerLime || block == BlockInit.flowerPink || block == BlockInit.flowerGray || block == BlockInit.flowerLightGray || block == BlockInit.flowerCyan || block == BlockInit.flowerPurple || block == BlockInit.flowerBlue || block == BlockInit.flowerBrown || block == BlockInit.flowerGreen || block == BlockInit.flowerRed || block == BlockInit.flowerBlack;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityPlantPot tileentity;
        super.getDrops(drops, world, pos, state, fortune);
        TileEntityPlantPot tileEntityPlantPot = tileentity = world.func_175625_s(pos) instanceof TileEntityPlantPot ? (TileEntityPlantPot)world.func_175625_s(pos) : null;
        if (tileentity != null && tileentity.getFlowerPotItem() != null) {
            drops.add((Object)new ItemStack(tileentity.getFlowerPotItem(), 1, tileentity.getFlowerPotData()));
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityPlantPot tileentityflowerpot;
        super.func_176208_a(world, pos, state, player);
        if (player.field_71075_bZ.field_75098_d && (tileentityflowerpot = this.getTileEntity(world, pos)) != null) {
            tileentityflowerpot.setItemStack(ItemStack.field_190927_a);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tileentity, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, tileentity, tool);
        world.func_175698_g(pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(world, pos) && (downState.func_185896_q() || downState.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        if (!downState.func_185896_q() && downState.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) != BlockFaceShape.SOLID) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stackhand = player.func_184586_b(hand);
        TileEntityPlantPot tileentity = this.getTileEntity(world, pos);
        if (tileentity == null) {
            return false;
        }
        ItemStack stacktile = tileentity.getFlowerItemStack();
        if (stacktile.func_190926_b()) {
            if (!this.canBePotted(stackhand)) {
                return false;
            }
            tileentity.setItemStack(stackhand);
            player.func_71029_a(StatList.field_188088_V);
            player.func_184185_a(SoundEvents.field_187577_bU, 1.0f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                stackhand.func_190918_g(1);
            }
        } else {
            if (stackhand.func_190926_b()) {
                player.func_184611_a(hand, stacktile);
            } else if (!player.func_191521_c(stacktile)) {
                player.func_71019_a(stacktile, false);
            }
            tileentity.setItemStack(ItemStack.field_190927_a);
        }
        tileentity.func_70296_d();
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONTENTS});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPlantPot(Item.func_150898_a(null), 0);
    }

    private TileEntityPlantPot getTileEntity(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity instanceof TileEntityPlantPot ? (TileEntityPlantPot)tileentity : null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177230_c() == BlockInit.potFlowerBlack) {
            return MapColor.field_193560_ab;
        }
        if (state.func_177230_c() == BlockInit.potFlowerBlue) {
            return MapColor.field_193572_X;
        }
        if (state.func_177230_c() == BlockInit.potFlowerBrown) {
            return MapColor.field_193573_Y;
        }
        if (state.func_177230_c() == BlockInit.potFlowerCyan) {
            return MapColor.field_193570_V;
        }
        if (state.func_177230_c() == BlockInit.potFlowerGray) {
            return MapColor.field_193568_T;
        }
        if (state.func_177230_c() == BlockInit.potFlowerGreen) {
            return MapColor.field_193574_Z;
        }
        if (state.func_177230_c() == BlockInit.potFlowerLightBlue) {
            return MapColor.field_193564_P;
        }
        if (state.func_177230_c() == BlockInit.potFlowerLightGray) {
            return MapColor.field_193569_U;
        }
        if (state.func_177230_c() == BlockInit.potFlowerLime) {
            return MapColor.field_193566_R;
        }
        if (state.func_177230_c() == BlockInit.potFlowerMagenta) {
            return MapColor.field_193563_O;
        }
        if (state.func_177230_c() == BlockInit.potFlowerOrange) {
            return MapColor.field_193562_N;
        }
        if (state.func_177230_c() == BlockInit.potFlowerPink) {
            return MapColor.field_193567_S;
        }
        if (state.func_177230_c() == BlockInit.potFlowerPurple) {
            return MapColor.field_193571_W;
        }
        if (state.func_177230_c() == BlockInit.potFlowerRed) {
            return MapColor.field_193559_aa;
        }
        if (state.func_177230_c() == BlockInit.potFlowerWhite) {
            return MapColor.field_193561_M;
        }
        if (state.func_177230_c() == BlockInit.potFlowerYellow) {
            return MapColor.field_193565_Q;
        }
        return null;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntityPlantPot tileentity = this.getTileEntity(world, pos);
        ItemStack itemstack = tileentity.getFlowerItemStack();
        if (tileentity != null && !itemstack.func_190926_b()) {
            return itemstack;
        }
        if (state.func_177230_c() == BlockInit.potFlowerBlack) {
            return new ItemStack((Block)BlockInit.potFlowerBlack);
        }
        if (state.func_177230_c() == BlockInit.potFlowerBlue) {
            return new ItemStack((Block)BlockInit.potFlowerBlue);
        }
        if (state.func_177230_c() == BlockInit.potFlowerBrown) {
            return new ItemStack((Block)BlockInit.potFlowerBrown);
        }
        if (state.func_177230_c() == BlockInit.potFlowerCyan) {
            return new ItemStack((Block)BlockInit.potFlowerCyan);
        }
        if (state.func_177230_c() == BlockInit.potFlowerGray) {
            return new ItemStack((Block)BlockInit.potFlowerGray);
        }
        if (state.func_177230_c() == BlockInit.potFlowerGreen) {
            return new ItemStack((Block)BlockInit.potFlowerGreen);
        }
        if (state.func_177230_c() == BlockInit.potFlowerLightBlue) {
            return new ItemStack((Block)BlockInit.potFlowerLightBlue);
        }
        if (state.func_177230_c() == BlockInit.potFlowerLightGray) {
            return new ItemStack((Block)BlockInit.potFlowerLightGray);
        }
        if (state.func_177230_c() == BlockInit.potFlowerLime) {
            return new ItemStack((Block)BlockInit.potFlowerLime);
        }
        if (state.func_177230_c() == BlockInit.potFlowerMagenta) {
            return new ItemStack((Block)BlockInit.potFlowerMagenta);
        }
        if (state.func_177230_c() == BlockInit.potFlowerOrange) {
            return new ItemStack((Block)BlockInit.potFlowerOrange);
        }
        if (state.func_177230_c() == BlockInit.potFlowerPink) {
            return new ItemStack((Block)BlockInit.potFlowerPink);
        }
        if (state.func_177230_c() == BlockInit.potFlowerPurple) {
            return new ItemStack((Block)BlockInit.potFlowerPurple);
        }
        if (state.func_177230_c() == BlockInit.potFlowerRed) {
            return new ItemStack((Block)BlockInit.potFlowerRed);
        }
        if (state.func_177230_c() == BlockInit.potFlowerWhite) {
            return new ItemStack((Block)BlockInit.potFlowerWhite);
        }
        if (state.func_177230_c() == BlockInit.potFlowerYellow) {
            return new ItemStack((Block)BlockInit.potFlowerYellow);
        }
        return null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityPlantPot tileentityflowerpot;
        Item item;
        TileEntity tileentity;
        EnumFlowerType blockflowerpot$enumflowertype = EnumFlowerType.EMPTY;
        TileEntity tileEntity = tileentity = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (tileentity instanceof TileEntityPlantPot && (item = (tileentityflowerpot = (TileEntityPlantPot)tileentity).getFlowerPotItem()) instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            if (block == BlockInit.flowerWhite) {
                blockflowerpot$enumflowertype = EnumFlowerType.WHITE;
            } else if (block == BlockInit.flowerOrange) {
                blockflowerpot$enumflowertype = EnumFlowerType.ORANGE;
            } else if (block == BlockInit.flowerMagenta) {
                blockflowerpot$enumflowertype = EnumFlowerType.MAGENTA;
            } else if (block == BlockInit.flowerLightBlue) {
                blockflowerpot$enumflowertype = EnumFlowerType.LIGHTBLUE;
            } else if (block == BlockInit.flowerYellow) {
                blockflowerpot$enumflowertype = EnumFlowerType.YELLOW;
            } else if (block == BlockInit.flowerLime) {
                blockflowerpot$enumflowertype = EnumFlowerType.LIME;
            } else if (block == BlockInit.flowerPink) {
                blockflowerpot$enumflowertype = EnumFlowerType.PINK;
            } else if (block == BlockInit.flowerGray) {
                blockflowerpot$enumflowertype = EnumFlowerType.GRAY;
            } else if (block == BlockInit.flowerLightGray) {
                blockflowerpot$enumflowertype = EnumFlowerType.LIGHTGRAY;
            } else if (block == BlockInit.flowerCyan) {
                blockflowerpot$enumflowertype = EnumFlowerType.CYAN;
            } else if (block == BlockInit.flowerPurple) {
                blockflowerpot$enumflowertype = EnumFlowerType.PURPLE;
            } else if (block == BlockInit.flowerBlue) {
                blockflowerpot$enumflowertype = EnumFlowerType.BLUE;
            } else if (block == BlockInit.flowerBrown) {
                blockflowerpot$enumflowertype = EnumFlowerType.BROWN;
            } else if (block == BlockInit.flowerGreen) {
                blockflowerpot$enumflowertype = EnumFlowerType.GREEN;
            } else if (block == BlockInit.flowerRed) {
                blockflowerpot$enumflowertype = EnumFlowerType.RED;
            } else if (block == BlockInit.flowerBlack) {
                blockflowerpot$enumflowertype = EnumFlowerType.BLACK;
            }
        }
        return state.func_177226_a(CONTENTS, (Comparable)((Object)blockflowerpot$enumflowertype));
    }

    public static enum EnumFlowerType implements IStringSerializable
    {
        EMPTY("empty"),
        WHITE("white"),
        ORANGE("orange"),
        MAGENTA("magenta"),
        LIGHTBLUE("lightblue"),
        YELLOW("yellow"),
        LIME("lime"),
        PINK("pink"),
        GRAY("gray"),
        LIGHTGRAY("lightgray"),
        CYAN("cyan"),
        PURPLE("purple"),
        BLUE("blue"),
        BROWN("brown"),
        GREEN("green"),
        RED("red"),
        BLACK("black");

        private final String name;

        private EnumFlowerType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

