/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.blocks;

import com.luxtracon.floralis.Main;
import com.luxtracon.floralis.inits.BlockInit;
import com.luxtracon.floralis.utilities.Config;
import com.luxtracon.floralis.utilities.TileEntityPlantPot;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockPotCactus
extends BlockContainer {
    public static final PropertyEnum<EnumCactusType> CONTENTS = PropertyEnum.func_177709_a((String)"contents", EnumCactusType.class);
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    public BlockPotCactus(String name, Material material) {
        super(material);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149647_a(Main.MODTAB);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONTENTS, (Comparable)((Object)EnumCactusType.EMPTY)));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean canBePotted(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        return block == BlockInit.cactusWhite || block == BlockInit.cactusOrange || block == BlockInit.cactusMagenta || block == BlockInit.cactusLightBlue || block == BlockInit.cactusYellow || block == BlockInit.cactusLime || block == BlockInit.cactusPink || block == BlockInit.cactusGray || block == BlockInit.cactusLightGray || block == BlockInit.cactusCyan || block == BlockInit.cactusPurple || block == BlockInit.cactusBlue || block == BlockInit.cactusBrown || block == BlockInit.cactusGreen || block == BlockInit.cactusRed || block == BlockInit.cactusBlack;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityPlantPot tileentity = this.getTileEntity(world, pos);
        ItemStack itemstack = tileentity.getFlowerItemStack();
        if (!itemstack.func_190926_b() && Config.cactidamage) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityPlantPot tileentity;
        super.getDrops(drops, world, pos, state, fortune);
        TileEntityPlantPot tileEntityPlantPot = tileentity = world.func_175625_s(pos) instanceof TileEntityPlantPot ? (TileEntityPlantPot)world.func_175625_s(pos) : null;
        if (tileentity != null && tileentity.getFlowerPotItem() != null) {
            drops.add((Object)new ItemStack(tileentity.getFlowerPotItem(), 1, tileentity.getFlowerPotData()));
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityPlantPot tileentityflowerpot;
        super.func_176208_a(world, pos, state, player);
        if (player.field_71075_bZ.field_75098_d && (tileentityflowerpot = this.getTileEntity(world, pos)) != null) {
            tileentityflowerpot.setItemStack(ItemStack.field_190927_a);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tileentity, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, tileentity, tool);
        world.func_175698_g(pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(world, pos) && (downState.func_185896_q() || downState.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        if (!downState.func_185896_q() && downState.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) != BlockFaceShape.SOLID) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stackhand = player.func_184586_b(hand);
        TileEntityPlantPot tileentity = this.getTileEntity(world, pos);
        if (tileentity == null) {
            return false;
        }
        ItemStack stacktile = tileentity.getFlowerItemStack();
        if (stacktile.func_190926_b()) {
            if (!this.canBePotted(stackhand)) {
                return false;
            }
            tileentity.setItemStack(stackhand);
            player.func_71029_a(StatList.field_188088_V);
            player.func_184185_a(SoundEvents.field_187577_bU, 1.0f, 1.0f);
            if (!player.field_71075_bZ.field_75098_d) {
                stackhand.func_190918_g(1);
            }
        } else {
            if (stackhand.func_190926_b()) {
                player.func_184611_a(hand, stacktile);
            } else if (!player.func_191521_c(stacktile)) {
                player.func_71019_a(stacktile, false);
            }
            tileentity.setItemStack(ItemStack.field_190927_a);
        }
        tileentity.func_70296_d();
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONTENTS});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPlantPot(Item.func_150898_a(null), 0);
    }

    private TileEntityPlantPot getTileEntity(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity instanceof TileEntityPlantPot ? (TileEntityPlantPot)tileentity : null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177230_c() == BlockInit.potCactusBlack) {
            return MapColor.field_193560_ab;
        }
        if (state.func_177230_c() == BlockInit.potCactusBlue) {
            return MapColor.field_193572_X;
        }
        if (state.func_177230_c() == BlockInit.potCactusBrown) {
            return MapColor.field_193573_Y;
        }
        if (state.func_177230_c() == BlockInit.potCactusCyan) {
            return MapColor.field_193570_V;
        }
        if (state.func_177230_c() == BlockInit.potCactusGray) {
            return MapColor.field_193568_T;
        }
        if (state.func_177230_c() == BlockInit.potCactusGreen) {
            return MapColor.field_193574_Z;
        }
        if (state.func_177230_c() == BlockInit.potCactusLightBlue) {
            return MapColor.field_193564_P;
        }
        if (state.func_177230_c() == BlockInit.potCactusLightGray) {
            return MapColor.field_193569_U;
        }
        if (state.func_177230_c() == BlockInit.potCactusLime) {
            return MapColor.field_193566_R;
        }
        if (state.func_177230_c() == BlockInit.potCactusMagenta) {
            return MapColor.field_193563_O;
        }
        if (state.func_177230_c() == BlockInit.potCactusOrange) {
            return MapColor.field_193562_N;
        }
        if (state.func_177230_c() == BlockInit.potCactusPink) {
            return MapColor.field_193567_S;
        }
        if (state.func_177230_c() == BlockInit.potCactusPurple) {
            return MapColor.field_193571_W;
        }
        if (state.func_177230_c() == BlockInit.potCactusRed) {
            return MapColor.field_193559_aa;
        }
        if (state.func_177230_c() == BlockInit.potCactusWhite) {
            return MapColor.field_193561_M;
        }
        if (state.func_177230_c() == BlockInit.potCactusYellow) {
            return MapColor.field_193565_Q;
        }
        return null;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileEntityPlantPot tileentity = this.getTileEntity(world, pos);
        ItemStack itemstack = tileentity.getFlowerItemStack();
        if (tileentity != null && !itemstack.func_190926_b()) {
            return itemstack;
        }
        if (state.func_177230_c() == BlockInit.potCactusBlack) {
            return new ItemStack((Block)BlockInit.potCactusBlack);
        }
        if (state.func_177230_c() == BlockInit.potCactusBlue) {
            return new ItemStack((Block)BlockInit.potCactusBlue);
        }
        if (state.func_177230_c() == BlockInit.potCactusBrown) {
            return new ItemStack((Block)BlockInit.potCactusBrown);
        }
        if (state.func_177230_c() == BlockInit.potCactusCyan) {
            return new ItemStack((Block)BlockInit.potCactusCyan);
        }
        if (state.func_177230_c() == BlockInit.potCactusGray) {
            return new ItemStack((Block)BlockInit.potCactusGray);
        }
        if (state.func_177230_c() == BlockInit.potCactusGreen) {
            return new ItemStack((Block)BlockInit.potCactusGreen);
        }
        if (state.func_177230_c() == BlockInit.potCactusLightBlue) {
            return new ItemStack((Block)BlockInit.potCactusLightBlue);
        }
        if (state.func_177230_c() == BlockInit.potCactusLightGray) {
            return new ItemStack((Block)BlockInit.potCactusLightGray);
        }
        if (state.func_177230_c() == BlockInit.potCactusLime) {
            return new ItemStack((Block)BlockInit.potCactusLime);
        }
        if (state.func_177230_c() == BlockInit.potCactusMagenta) {
            return new ItemStack((Block)BlockInit.potCactusMagenta);
        }
        if (state.func_177230_c() == BlockInit.potCactusOrange) {
            return new ItemStack((Block)BlockInit.potCactusOrange);
        }
        if (state.func_177230_c() == BlockInit.potCactusPink) {
            return new ItemStack((Block)BlockInit.potCactusPink);
        }
        if (state.func_177230_c() == BlockInit.potCactusPurple) {
            return new ItemStack((Block)BlockInit.potCactusPurple);
        }
        if (state.func_177230_c() == BlockInit.potCactusRed) {
            return new ItemStack((Block)BlockInit.potCactusRed);
        }
        if (state.func_177230_c() == BlockInit.potCactusWhite) {
            return new ItemStack((Block)BlockInit.potCactusWhite);
        }
        if (state.func_177230_c() == BlockInit.potCactusYellow) {
            return new ItemStack((Block)BlockInit.potCactusYellow);
        }
        return null;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityPlantPot tileentityflowerpot;
        Item item;
        TileEntity tileentity;
        EnumCactusType blockflowerpot$enumflowertype = EnumCactusType.EMPTY;
        TileEntity tileEntity = tileentity = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (tileentity instanceof TileEntityPlantPot && (item = (tileentityflowerpot = (TileEntityPlantPot)tileentity).getFlowerPotItem()) instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            if (block == BlockInit.cactusWhite) {
                blockflowerpot$enumflowertype = EnumCactusType.WHITE;
            } else if (block == BlockInit.cactusOrange) {
                blockflowerpot$enumflowertype = EnumCactusType.ORANGE;
            } else if (block == BlockInit.cactusMagenta) {
                blockflowerpot$enumflowertype = EnumCactusType.MAGENTA;
            } else if (block == BlockInit.cactusLightBlue) {
                blockflowerpot$enumflowertype = EnumCactusType.LIGHTBLUE;
            } else if (block == BlockInit.cactusYellow) {
                blockflowerpot$enumflowertype = EnumCactusType.YELLOW;
            } else if (block == BlockInit.cactusLime) {
                blockflowerpot$enumflowertype = EnumCactusType.LIME;
            } else if (block == BlockInit.cactusPink) {
                blockflowerpot$enumflowertype = EnumCactusType.PINK;
            } else if (block == BlockInit.cactusGray) {
                blockflowerpot$enumflowertype = EnumCactusType.GRAY;
            } else if (block == BlockInit.cactusLightGray) {
                blockflowerpot$enumflowertype = EnumCactusType.LIGHTGRAY;
            } else if (block == BlockInit.cactusCyan) {
                blockflowerpot$enumflowertype = EnumCactusType.CYAN;
            } else if (block == BlockInit.cactusPurple) {
                blockflowerpot$enumflowertype = EnumCactusType.PURPLE;
            } else if (block == BlockInit.cactusBlue) {
                blockflowerpot$enumflowertype = EnumCactusType.BLUE;
            } else if (block == BlockInit.cactusBrown) {
                blockflowerpot$enumflowertype = EnumCactusType.BROWN;
            } else if (block == BlockInit.cactusGreen) {
                blockflowerpot$enumflowertype = EnumCactusType.GREEN;
            } else if (block == BlockInit.cactusRed) {
                blockflowerpot$enumflowertype = EnumCactusType.RED;
            } else if (block == BlockInit.cactusBlack) {
                blockflowerpot$enumflowertype = EnumCactusType.BLACK;
            }
        }
        return state.func_177226_a(CONTENTS, (Comparable)((Object)blockflowerpot$enumflowertype));
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_CACTUS;
    }

    public static enum EnumCactusType implements IStringSerializable
    {
        EMPTY("empty"),
        WHITE("white"),
        ORANGE("orange"),
        MAGENTA("magenta"),
        LIGHTBLUE("lightblue"),
        YELLOW("yellow"),
        LIME("lime"),
        PINK("pink"),
        GRAY("gray"),
        LIGHTGRAY("lightgray"),
        CYAN("cyan"),
        PURPLE("purple"),
        BLUE("blue"),
        BROWN("brown"),
        GREEN("green"),
        RED("red"),
        BLACK("black");

        private final String name;

        private EnumCactusType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

