/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.blocks;

import com.luxtracon.floralis.Main;
import com.luxtracon.floralis.inits.BlockInit;
import com.luxtracon.floralis.inits.ItemInit;
import com.luxtracon.floralis.utilities.Config;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

public class BlockPlantCactus
extends Block
implements IPlantable,
IShearable {
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    public static final AxisAlignedBB COLLISIONAABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);

    public BlockPlantCactus(String name, Material material) {
        super(material);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149647_a(Main.MODTAB);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        boolean up = world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d();
        boolean north = world.func_180495_p(pos.func_177978_c()).func_185904_a().func_76224_d();
        boolean south = world.func_180495_p(pos.func_177968_d()).func_185904_a().func_76224_d();
        boolean east = world.func_180495_p(pos.func_177974_f()).func_185904_a().func_76224_d();
        boolean west = world.func_180495_p(pos.func_177976_e()).func_185904_a().func_76224_d();
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150354_m && !up && !north && !south && !east && !west;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 300;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177230_c() == BlockInit.cactusBlack) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusBlack, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalBlack, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsBlack, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusBlue) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusBlue, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalBlue, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsBlue, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusBrown) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusBrown, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalBrown, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsBrown, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusCyan) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusCyan, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalCyan, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsCyan, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusGray) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusGray, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalGray, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsGray, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusGreen) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusGreen, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalGreen, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsGreen, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusLightBlue) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusLightBlue, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalLightBlue, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsLightBlue, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusLightGray) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusLightGray, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalLightGray, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsLightGray, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusLime) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusLime, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalLime, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsLime, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusMagenta) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusMagenta, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalMagenta, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsMagenta, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusOrange) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusOrange, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalOrange, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsOrange, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusPink) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusPink, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalPink, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsPink, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusPurple) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusPurple, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalPurple, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsPurple, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusRed) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusRed, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalRed, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsRed, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusWhite) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusWhite, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalWhite, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsWhite, 1 + fortune));
        }
        if (state.func_177230_c() == BlockInit.cactusYellow) {
            drops.add((Object)new ItemStack((Item)ItemInit.seedCactusYellow, 2 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.petalYellow, 1 + fortune));
            drops.add((Object)new ItemStack((Item)ItemInit.partsYellow, 1 + fortune));
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (Config.cactidamage) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return COLLISIONAABB;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumPlantType getPlantType(IBlockAccess source, BlockPos pos) {
        return EnumPlantType.Desert;
    }

    public IBlockState getPlant(IBlockAccess source, BlockPos pos) {
        return null;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return Collections.singletonList(new ItemStack((Block)this));
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_CACTUS;
    }
}

