/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis;

import com.luxtracon.floralis.compats.ForestryFarming;
import com.luxtracon.floralis.compats.ImmersiveEngineering;
import com.luxtracon.floralis.compats.IndustrialForegoing;
import com.luxtracon.floralis.compats.ThermalExpansion;
import com.luxtracon.floralis.inits.BlockInit;
import com.luxtracon.floralis.inits.ItemInit;
import com.luxtracon.floralis.proxies.CommonProxy;
import com.luxtracon.floralis.registries.DictionaryRegistry;
import com.luxtracon.floralis.registries.GeneratorRegistry;
import com.luxtracon.floralis.registries.HandlerRegistry;
import com.luxtracon.floralis.registries.SmeltingRegistry;
import com.luxtracon.floralis.registries.StructureRegistry;
import com.luxtracon.floralis.registries.TradesRegistry;
import com.luxtracon.floralis.utilities.Config;
import com.luxtracon.floralis.utilities.Tab;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="floralis", dependencies="after:forestry;after:immersiveengineering;after:industrialforegoing;after:thermalexpansion")
public class Main {
    public static final String MODID = "floralis";
    public static final String CLIENT = "com.luxtracon.floralis.proxies.ClientProxy";
    public static final String COMMON = "com.luxtracon.floralis.proxies.CommonProxy";
    public static final String MODDEPENDENCIES = "after:forestry;after:immersiveengineering;after:industrialforegoing;after:thermalexpansion";
    public static final CreativeTabs MODTAB = new Tab();
    private static boolean isForestryFarmingPresent;
    private static boolean isImmersiveEngineeringPresent;
    private static boolean isIndustrialForegoingPresent;
    private static boolean isThermalExpansionPresent;
    @SidedProxy(clientSide="com.luxtracon.floralis.proxies.ClientProxy", serverSide="com.luxtracon.floralis.proxies.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public static void onConstructionEvent(FMLConstructionEvent event) {
        isForestryFarmingPresent = Loader.isModLoaded((String)"forestry");
        isImmersiveEngineeringPresent = Loader.isModLoaded((String)"immersiveengineering");
        isIndustrialForegoingPresent = Loader.isModLoaded((String)"industrialforegoing");
        isThermalExpansionPresent = Loader.isModLoaded((String)"thermalexpansion");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        BlockInit.init();
        ItemInit.init();
        Config.init(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (isForestryFarmingPresent && Config.ffcompat) {
            ForestryFarming.init();
        }
        if (isImmersiveEngineeringPresent && Config.iecompat) {
            ImmersiveEngineering.init();
        }
        if (isIndustrialForegoingPresent && Config.ifcompat) {
            IndustrialForegoing.init();
        }
        if (isThermalExpansionPresent && Config.tecompat) {
            ThermalExpansion.init();
        }
        proxy.init();
        HandlerRegistry.init();
        DictionaryRegistry.init();
        GeneratorRegistry.init();
        SmeltingRegistry.init();
        StructureRegistry.init();
        TradesRegistry.init();
    }
}

