/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OredictHelper {
    private static List<String> allOres = Lists.newArrayList();
    private static List<String> allIngots = Lists.newArrayList();
    private static List<String> allDusts = Lists.newArrayList();
    private static List<String> allOres_ = Collections.unmodifiableList(allOres);
    private static List<String> allIngots_ = Collections.unmodifiableList(allIngots);
    private static List<String> allDusts_ = Collections.unmodifiableList(allDusts);

    public static void initLists() {
        String[] names;
        allDusts.clear();
        allIngots.clear();
        allOres.clear();
        for (String s : names = OreDictionary.getOreNames()) {
            if (Strings.isNullOrEmpty((String)s)) continue;
            if (s.startsWith("ore")) {
                allOres.add(s);
                continue;
            }
            if (s.startsWith("ingot")) {
                allIngots.add(s);
                continue;
            }
            if (!s.startsWith("dust")) continue;
            allDusts.add(s);
        }
    }

    public static List<String> getAllOres() {
        return allOres_;
    }

    public static List<String> getAllIngots() {
        return allIngots_;
    }

    public static List<String> getAllDusts() {
        return allDusts_;
    }

    public static String concatOreName(String oreName) {
        return oreName.replace("ore", "");
    }

    public static String concatIngotName(String ingotName) {
        return ingotName.replace("ingot", "");
    }

    public static boolean isOre(ItemStack stack) {
        return OredictHelper.getOreIDs(stack).length > 0;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList ret = Lists.newArrayList();
        for (int i : OredictHelper.getOreIDs(stack)) {
            ret.add(OreDictionary.getOreName((int)i));
        }
        return ret;
    }

    public static int[] getOreIDs(ItemStack stack) {
        return OreDictionary.getOreIDs((ItemStack)stack);
    }

    public static List<ItemStack> getOres(String name) {
        return OredictHelper.getOres(name, false);
    }

    public static List<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        return OreDictionary.getOres((String)name, (boolean)alwaysCreateEntry);
    }
}

