/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.tile;

import com.google.common.collect.Maps;
import elec332.core.ElecCore;
import elec332.core.inventory.window.IWindowHandler;
import elec332.core.inventory.window.WindowManager;
import elec332.core.network.IElecCoreNetworkTile;
import elec332.core.network.packets.PacketTileDataToServer;
import elec332.core.util.NBTTypes;
import elec332.core.util.ServerHelper;
import elec332.core.world.WorldHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AbstractTileEntity
extends TileEntity
implements IElecCoreNetworkTile {
    private boolean isGatheringPackets;
    private Map<Integer, NBTTagCompound> gatherData;

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Deprecated
    public boolean openGui(EntityPlayer player, Object mod, int guiID) {
        player.openGui(mod, guiID, this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        return true;
    }

    public boolean openWindow(EntityPlayer player, IWindowHandler windowHandler, int id) {
        WindowManager.openWindow(player, windowHandler, this.func_145831_w(), this.field_174879_c, (byte)id);
        return true;
    }

    public void reRenderBlock() {
        WorldHelper.markBlockForRenderUpdate(this.field_145850_b, this.field_174879_c);
    }

    public void notifyNeighborsOfChange() {
        WorldHelper.notifyNeighborsOfStateChange(this.func_145831_w(), this.field_174879_c, this.field_145854_h);
    }

    public void syncData() {
        WorldHelper.markBlockForUpdate(this.func_145831_w(), this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendPacketToServer(int ID, NBTTagCompound data) {
        ElecCore.networkHandler.sendToServer(new PacketTileDataToServer(this, ID, data));
    }

    @Override
    public void onPacketReceivedFromClient(EntityPlayerMP sender, int ID, NBTTagCompound data) {
    }

    public void sendPacket(int ID, NBTTagCompound data) {
        if (this.isGatheringPackets) {
            this.gatherData.put(ID, data);
            return;
        }
        for (EntityPlayerMP player : ServerHelper.getAllPlayersWatchingBlock(this.func_145831_w(), this.func_174877_v())) {
            this.sendPacketTo(player, ID, data);
        }
    }

    public void sendPacketTo(EntityPlayerMP player, int ID, NBTTagCompound data) {
        player.field_71135_a.func_147359_a((Packet)new SPacketUpdateTileEntity(this.func_174877_v(), ID, data));
    }

    public void syncTile() {
        this.sendPacket(0, this.func_189517_E_());
    }

    public void sendInitialLoadPackets() {
    }

    @Nonnull
    @Deprecated
    public NBTTagCompound func_189517_E_() {
        this.isGatheringPackets = true;
        this.gatherData = Maps.newHashMap();
        this.sendInitialLoadPackets();
        this.isGatheringPackets = false;
        NBTTagCompound tag = this.getInitialData();
        if (!this.gatherData.isEmpty()) {
            NBTTagList list = new NBTTagList();
            this.gatherData.forEach((key, value) -> {
                NBTTagCompound tag1 = new NBTTagCompound();
                tag1.func_74768_a("pid", key.intValue());
                tag1.func_74782_a("pda", (NBTBase)value);
                list.func_74742_a((NBTBase)tag1);
            });
            tag.func_74782_a("morePackets_eD", (NBTBase)list);
        }
        return tag;
    }

    public NBTTagCompound getInitialData() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NBTTagCompound getDefaultUpdateTag() {
        return super.func_189517_E_();
    }

    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        NBTTagList p = tag.func_150295_c("morePackets_eD", (int)NBTTypes.COMPOUND.getID());
        tag.func_82580_o("morePackets_eD");
        this.func_145839_a(tag);
        this.onDataPacket(0, tag);
        for (int i = 0; i < p.func_74745_c(); ++i) {
            NBTTagCompound tag_ = p.func_150305_b(i);
            this.onDataPacket(tag_.func_74762_e("pid"), tag_.func_74775_l("pda"));
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (packet.func_148853_f() == 0) {
            this.func_145839_a(packet.func_148857_g());
            this.onDataPacket(0, packet.func_148857_g());
        } else {
            this.onDataPacket(packet.func_148853_f(), packet.func_148857_g());
        }
    }

    @Override
    public void onDataPacket(int id, NBTTagCompound tag) {
    }
}

