/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.module;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import elec332.core.api.module.IModuleController;
import elec332.core.api.module.IModuleInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;

public class DefaultModuleInfo
implements IModuleInfo {
    private final String owner;
    private final String name;
    private final String clazz;
    private final ResourceLocation combinedName;
    private final boolean autoDIRNM;
    private final boolean alwaysEnabled;
    private final List<ArtifactVersion> modDeps;
    private final List<String> moduleDeps;
    private final IModuleController moduleController;

    public DefaultModuleInfo(IModuleInfo info) {
        this(info.getOwner(), info.getName(), info.getModDependencies(), info.getModuleDependencies(), info.autoDisableIfRequirementsNotMet(), info.alwaysEnabled(), info.getModuleClass(), info.getModuleController(), info.getCombinedName());
    }

    public DefaultModuleInfo(String owner, String name, String modDeps, String moduleDeps, boolean ADRIM, boolean alwaysOn, String mainClazz, IModuleController moduleController) {
        this(owner, name, IModuleInfo.parseDependencyInfo(modDeps), (List<String>)(Strings.isNullOrEmpty((String)moduleDeps) ? ImmutableList.of() : ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])moduleDeps.split(";")))), ADRIM, alwaysOn, mainClazz, moduleController, new ResourceLocation(owner, name.toLowerCase()));
    }

    public DefaultModuleInfo(String owner, String name, List<ArtifactVersion> modDeps, List<String> moduleDeps, boolean ADRIM, boolean alwaysOn, String mainClazz, IModuleController moduleController, ResourceLocation combinedName) {
        this.owner = Objects.requireNonNull(owner);
        this.name = Objects.requireNonNull(name);
        this.modDeps = Objects.requireNonNull(modDeps);
        this.moduleDeps = Objects.requireNonNull(moduleDeps);
        this.autoDIRNM = ADRIM;
        this.alwaysEnabled = alwaysOn;
        this.clazz = Objects.requireNonNull(mainClazz);
        this.moduleController = Objects.requireNonNull(moduleController);
        this.combinedName = Objects.requireNonNull(combinedName);
    }

    @Override
    @Nonnull
    public String getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public ResourceLocation getCombinedName() {
        return this.combinedName;
    }

    @Override
    public boolean autoDisableIfRequirementsNotMet() {
        return this.autoDIRNM;
    }

    @Override
    @Nonnull
    public List<ArtifactVersion> getModDependencies() {
        return this.modDeps;
    }

    @Override
    @Nonnull
    public List<String> getModuleDependencies() {
        return this.moduleDeps;
    }

    @Override
    @Nonnull
    public String getModuleClass() {
        return this.clazz;
    }

    @Override
    public boolean alwaysEnabled() {
        return this.alwaysEnabled;
    }

    @Override
    @Nonnull
    public IModuleController getModuleController() {
        return this.moduleController;
    }
}

