/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.loader;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.api.APIHandlerInject;
import elec332.core.api.IAPIHandler;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import elec332.core.api.discovery.IAdvancedASMData;
import elec332.core.util.FMLUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;

enum ASMDataHandler {
    INSTANCE;

    private static final boolean useCache = false;
    private final Map<LoaderState, List<IASMDataProcessor>> asmLoaderMap = Maps.newHashMap();
    private final List<LoaderState> validStates = ImmutableList.of((Object)LoaderState.CONSTRUCTING, (Object)LoaderState.PREINITIALIZATION, (Object)LoaderState.INITIALIZATION, (Object)LoaderState.POSTINITIALIZATION, (Object)LoaderState.AVAILABLE);
    private IASMDataHelper asmDataHelper;
    private Map<String, Boolean> sideOnlyCache = Maps.newHashMap();
    private Predicate<String> hasSideOnly;

    void identify(final ASMDataTable dataTable) {
        for (LoaderState state : this.validStates) {
            this.asmLoaderMap.put(state, Lists.newArrayList());
        }
        this.hasSideOnly = cls -> this.sideOnlyCache.computeIfAbsent((String)cls, name -> this.asmDataHelper.getAnnotationList(SideOnly.class).stream().anyMatch(asmData -> asmData.getClassName().equals(cls)));
        this.asmDataHelper = new IASMDataHelper(){
            private final Map<String, Set<IAdvancedASMData>> annotationData = Maps.newHashMap();

            @Override
            public ASMDataTable getASMDataTable() {
                return dataTable;
            }

            @Override
            public Set<ASMDataTable.ASMData> getAnnotationList(Class<? extends Annotation> annotationClass) {
                return this.getASMDataTable().getAll(annotationClass.getName());
            }

            @Override
            public Set<IAdvancedASMData> getAdvancedAnnotationList(Class<? extends Annotation> annotationClass) {
                String s = annotationClass.getName();
                return this.createNew(s);
            }

            @Override
            public boolean hasSideOnlyAnnotation(String clazz) {
                return ASMDataHandler.this.hasSideOnly.test(clazz);
            }

            private Set<IAdvancedASMData> createNew(String s) {
                HashSet ret = Sets.newHashSet();
                for (ASMDataTable.ASMData data : this.getASMDataTable().getAll(s)) {
                    ret.add(new AdvancedASMData(data));
                }
                return ImmutableSet.copyOf((Collection)ret);
            }
        };
        TreeMap dataMap = Maps.newTreeMap(Comparator.comparing(Pair::getKey).reversed().thenComparing(Object::hashCode));
        for (ASMDataTable.ASMData aSMData : this.asmDataHelper.getAnnotationList(ASMDataProcessor.class)) {
            Class<?> clazz;
            boolean eb = false;
            try {
                clazz = Class.forName(aSMData.getClassName());
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (clazz == null) continue;
            if (clazz.isAnnotationPresent(ASMDataProcessor.class)) {
                ASMDataProcessor annData = clazz.getAnnotation(ASMDataProcessor.class);
                LoaderState[] ls = annData.value();
                int importance = annData.importance();
                if (clazz.isEnum()) {
                    for (Object e : clazz.getEnumConstants()) {
                        if (!(e instanceof IASMDataProcessor)) continue;
                        dataMap.put(Pair.of((Object)importance, (Object)((IASMDataProcessor)e)), ls);
                    }
                    eb = true;
                } else {
                    Object o;
                    try {
                        o = clazz.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error invocating annotated IASMData class: " + aSMData.getClassName(), e);
                    }
                    if (o instanceof IASMDataProcessor) {
                        dataMap.put(Pair.of((Object)importance, (Object)((IASMDataProcessor)o)), ls);
                    }
                }
            }
            if (eb) continue;
            for (Field field : clazz.getDeclaredFields()) {
                Object obj;
                if (!field.isAnnotationPresent(ASMDataProcessor.class)) continue;
                try {
                    obj = field.get(null);
                }
                catch (Exception e) {
                    continue;
                }
                if (!(obj instanceof IASMDataProcessor)) continue;
                ASMDataProcessor annData = field.getAnnotation(ASMDataProcessor.class);
                dataMap.put(Pair.of((Object)annData.importance(), (Object)((IASMDataProcessor)obj)), annData.value());
            }
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            LoaderState[] hS = (LoaderState[])entry.getValue();
            if (hS == null || hS.length == 0) {
                throw new IllegalArgumentException("Invalid LoaderState parameters: Null or empty array; For " + ((IASMDataProcessor)((Pair)entry.getKey()).getValue()).getClass());
            }
            for (LoaderState state : hS) {
                if (!this.validStates.contains(state)) {
                    throw new IllegalArgumentException("Invalid LoaderState parameter: " + state + "; For " + ((IASMDataProcessor)((Pair)entry.getKey()).getValue()).getClass());
                }
                this.asmLoaderMap.get(state).add((IASMDataProcessor)((Pair)entry.getKey()).getValue());
            }
        }
    }

    void process(LoaderState state) {
        if (this.validStates.contains(state)) {
            List<IASMDataProcessor> dataProcessors = this.asmLoaderMap.get(state);
            for (IASMDataProcessor dataProcessor : dataProcessors) {
                dataProcessor.processASMData(this.asmDataHelper, state);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.asmLoaderMap.remove(state);
    }

    @APIHandlerInject(weight=1)
    public void injectASMHelper(IAPIHandler apiHandler) {
        apiHandler.inject(this.asmDataHelper, IASMDataHelper.class);
    }

    private class AdvancedASMData
    implements IAdvancedASMData {
        private final ASMDataTable.ASMData asmData;
        private final Map<String, Object> annotationInfo;
        private final boolean isField;
        private final boolean isClass;
        private Class<?> clazz;
        private Field field;
        private String methodName;
        private String methodParams;
        private Method method;
        private Type[] paramTypes;
        private Class[] params;
        private Boolean sideOnly;

        private AdvancedASMData(ASMDataTable.ASMData asmData) {
            this.asmData = asmData;
            this.isField = asmData.getObjectName().indexOf(40) == -1;
            this.isClass = asmData.getObjectName().indexOf(46) != -1;
            this.annotationInfo = Collections.unmodifiableMap(asmData.getAnnotationInfo());
        }

        @Override
        public ModCandidate getContainer() {
            return this.asmData.getCandidate();
        }

        @Override
        public String getAnnotationName() {
            return this.asmData.getAnnotationName();
        }

        @Override
        public Map<String, Object> getAnnotationInfo() {
            return this.annotationInfo;
        }

        @Override
        public String getClassName() {
            return this.asmData.getClassName();
        }

        @Override
        public Class<?> loadClass() {
            if (this.clazz != null) {
                return this.clazz;
            }
            try {
                this.clazz = FMLUtil.loadClass(this.asmData.getClassName());
                return this.clazz;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isField() {
            return this.isField && !this.isClass;
        }

        @Override
        public String getFieldName() {
            if (!this.isField()) {
                throw new IllegalAccessError();
            }
            return this.asmData.getObjectName();
        }

        @Override
        public Field getField() {
            if (this.field != null) {
                return this.field;
            }
            if (!this.isField()) {
                throw new IllegalAccessError();
            }
            try {
                this.field = this.loadClass().getDeclaredField(this.getFieldName());
                this.field.setAccessible(true);
                return this.field;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Class<?> getFieldType() {
            return this.getField().getType();
        }

        @Override
        public boolean isMethod() {
            return !this.isField && !this.isClass;
        }

        @Override
        public String getMethodName() {
            if (!this.isMethod()) {
                throw new IllegalAccessError();
            }
            if (this.methodName == null) {
                String targetName = this.asmData.getObjectName();
                int i = targetName.indexOf(40);
                int i2 = targetName.indexOf(41);
                this.methodName = targetName.substring(0, i);
                if (i2 - i == 1) {
                    this.methodParams = "";
                    this.paramTypes = new Type[0];
                    this.params = new Class[0];
                } else {
                    this.methodParams = targetName.substring(i, i2 + 1);
                }
            }
            return this.methodName;
        }

        @Override
        public Method getMethod() {
            if (this.method != null) {
                return this.method;
            }
            if (!this.isMethod()) {
                throw new IllegalAccessError();
            }
            try {
                this.method = this.loadClass().getDeclaredMethod(this.getMethodName(), this.getMethodParameters());
                this.method.setAccessible(true);
                return this.method;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Type[] getMethodParameterTypes() {
            if (this.methodParams == null) {
                this.getMethodName();
            }
            if (this.paramTypes != null) {
                return this.paramTypes;
            }
            this.paramTypes = Type.getArgumentTypes((String)this.methodParams);
            return this.paramTypes;
        }

        @Override
        public Class<?>[] getMethodParameters() {
            if (this.params != null) {
                return this.params;
            }
            if (!this.isMethod()) {
                throw new IllegalAccessError();
            }
            Type[] p = this.getMethodParameterTypes();
            Class[] ret = new Class[p.length];
            try {
                for (int i = 0; i < p.length; ++i) {
                    ret[i] = Class.forName(p[i].getClassName());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.params = ret;
            return ret;
        }

        @Override
        public boolean hasSideOnlyAnnotation() {
            if (this.sideOnly == null) {
                this.sideOnly = ASMDataHandler.this.hasSideOnly.test(this.getClassName());
            }
            return this.sideOnly;
        }

        public String toString() {
            return " Annotation:" + this.getAnnotationName() + " Class:" + this.getClassName() + " Field name:" + (this.isField() ? this.getFieldName() : "-") + " Method name:" + (this.isMethod() ? this.getMethodName() : "-") + " Annotation data:" + this.getAnnotationInfo();
        }
    }
}

