/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.handler;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class TickHandler {
    private final Queue<Runnable> clientCallbacks = new ArrayDeque<Runnable>();
    private final Queue<Runnable> serverCallbacks = new ArrayDeque<Runnable>();
    private final Queue<Runnable> clientTickables = new ArrayDeque<Runnable>();
    private final Queue<Runnable> serverTickables = new ArrayDeque<Runnable>();

    public TickHandler() {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onTick(TickEvent.ServerTickEvent event) {
                TickHandler.this.processSingleTicks((TickEvent)event, TickHandler.this.serverCallbacks);
                TickHandler.this.processTickables((TickEvent)event, TickHandler.this.serverTickables);
            }

            @SubscribeEvent
            public void onTickClient(TickEvent.ClientTickEvent event) {
                TickHandler.this.processSingleTicks((TickEvent)event, TickHandler.this.clientCallbacks);
                TickHandler.this.processTickables((TickEvent)event, TickHandler.this.clientTickables);
            }
        });
    }

    public void registerCall(Runnable runnable, World world) {
        this.register(runnable, ((World)Preconditions.checkNotNull((Object)world)).field_72995_K, this.clientCallbacks, this.serverCallbacks);
    }

    public void registerCall(Runnable runnable, Side side) {
        this.register(runnable, ((Side)Preconditions.checkNotNull((Object)side)).isClient(), this.clientCallbacks, this.serverCallbacks);
    }

    public void registerTickable(Runnable runnable, World world) {
        this.register(runnable, ((World)Preconditions.checkNotNull((Object)world)).field_72995_K, this.clientTickables, this.serverTickables);
    }

    public void registerTickable(Runnable runnable, Side side) {
        this.register(runnable, ((Side)Preconditions.checkNotNull((Object)side)).isClient(), this.clientTickables, this.serverTickables);
    }

    public void registerCallServer(Runnable runnable) {
        this.serverCallbacks.add((Runnable)Preconditions.checkNotNull((Object)runnable));
    }

    public void registerCallClient(Runnable runnable) {
        this.clientCallbacks.add((Runnable)Preconditions.checkNotNull((Object)runnable));
    }

    public void registerServerTickable(Runnable runnable) {
        this.serverTickables.add(runnable);
    }

    public void registerClientTickable(Runnable runnable) {
        this.clientTickables.add(runnable);
    }

    public void removeTickable(Runnable runnable) {
        this.serverTickables.remove(runnable);
        this.clientTickables.remove(runnable);
    }

    private void register(Runnable runnable, boolean client, Queue<Runnable> clC, Queue<Runnable> srvC) {
        (client ? clC : srvC).add((Runnable)Preconditions.checkNotNull((Object)runnable));
    }

    private void processSingleTicks(TickEvent event, Queue<Runnable> process) {
        if (event.phase == TickEvent.Phase.START && !process.isEmpty()) {
            Runnable runnable = process.poll();
            while (runnable != null) {
                runnable.run();
                runnable = process.poll();
            }
            process.clear();
        }
    }

    private void processTickables(TickEvent event, Queue<Runnable> process) {
        if (event.phase == TickEvent.Phase.START && !process.isEmpty()) {
            for (Runnable runnable : process) {
                runnable.run();
            }
        }
    }
}

