/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.template;

import com.google.common.collect.Lists;
import elec332.core.api.client.model.template.IModelTemplate;
import elec332.core.api.client.model.template.IMutableModelTemplate;
import elec332.core.api.client.model.template.IQuadTemplate;
import elec332.core.api.client.model.template.IQuadTemplateSidedMap;
import elec332.core.client.model.ElecModelBakery;
import elec332.core.client.model.template.MutableQuadSidedMap;
import elec332.core.client.model.template.MutableQuadTemplate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MutableModelTemplate
implements IMutableModelTemplate {
    private boolean ao;
    private boolean gui3d;
    private boolean builtIn;
    private TextureAtlasSprite texture;
    private ItemCameraTransforms transforms = ItemCameraTransforms.field_178357_a;
    private List<IQuadTemplate> generalQuads;
    private IQuadTemplateSidedMap sidedQuads;

    @Nonnull
    public static MutableModelTemplate newDefaultItemTemplate() {
        return MutableModelTemplate.newTemplate().setItemCameraTransforms(ElecModelBakery.DEFAULT_ITEM);
    }

    @Nonnull
    public static MutableModelTemplate newDefaultBlockTemplate() {
        return MutableModelTemplate.newTemplate().setGui3d(true).setItemCameraTransforms(ElecModelBakery.DEFAULT_BLOCK);
    }

    @Nonnull
    public static MutableModelTemplate newTemplate() {
        return new MutableModelTemplate();
    }

    @Nonnull
    public static MutableModelTemplate copyOf(IModelTemplate template) {
        MutableModelTemplate ret = MutableModelTemplate.newTemplate();
        ret.ao = template.isAmbientOcclusion();
        ret.gui3d = template.isGui3d();
        ret.builtIn = template.isBuiltInRenderer();
        ret.texture = template.getTexture();
        ret.transforms = template.getItemCameraTransforms();
        ret.generalQuads = Lists.newArrayList();
        for (IQuadTemplate quadTemplate : template.getGeneralQuads()) {
            ret.generalQuads.add(MutableQuadTemplate.copyOf(quadTemplate));
        }
        ret.sidedQuads = MutableQuadSidedMap.newQuadSidedMap();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ArrayList toAdd = Lists.newArrayList();
            for (IQuadTemplate quadTemplate : template.getSidedQuads().getForSide(facing)) {
                toAdd.add(MutableQuadTemplate.copyOf(quadTemplate));
            }
            ret.sidedQuads.setQuadsForSide(facing, toAdd);
        }
        return ret;
    }

    private MutableModelTemplate() {
    }

    @Override
    public MutableModelTemplate setGeneralQuads(List<IQuadTemplate> generalQuads) {
        this.generalQuads = generalQuads;
        return this;
    }

    @Override
    public MutableModelTemplate setSidedQuads(IQuadTemplateSidedMap sidedQuads) {
        this.sidedQuads = sidedQuads;
        return this;
    }

    @Override
    public MutableModelTemplate setAmbientOcclusion(boolean ao) {
        this.ao = ao;
        return this;
    }

    @Override
    public MutableModelTemplate setGui3d(boolean gui3d) {
        this.gui3d = gui3d;
        return this;
    }

    @Override
    public MutableModelTemplate setBuiltIn(boolean builtIn) {
        this.builtIn = builtIn;
        return this;
    }

    @Override
    public MutableModelTemplate setTexture(TextureAtlasSprite texture) {
        this.texture = texture;
        return this;
    }

    @Override
    public MutableModelTemplate setItemCameraTransforms(ItemCameraTransforms transforms) {
        this.transforms = transforms;
        return this;
    }

    @Override
    public List<IQuadTemplate> getGeneralQuads() {
        return this.generalQuads;
    }

    @Override
    public IQuadTemplateSidedMap getSidedQuads() {
        return this.sidedQuads;
    }

    @Override
    public boolean isAmbientOcclusion() {
        return this.ao;
    }

    @Override
    public boolean isGui3d() {
        return this.gui3d;
    }

    @Override
    public boolean isBuiltInRenderer() {
        return this.builtIn;
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return this.texture;
    }

    @Override
    public ItemCameraTransforms getItemCameraTransforms() {
        return this.transforms;
    }
}

