/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui.swing;

import com.brandon3055.projectintelligence.client.PIGuiHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MDTagDialog
extends JDialog {
    private TagType type;
    private JLabel alignLabel;
    private JComboBox<String> alignSelector;
    private JTextField colourField1;
    private JTextField colourField2;
    private JTextField colourField3;
    private JTextField colourField4;
    private JLabel colourLabel1;
    private JLabel colourLabel2;
    private JLabel colourLabel3;
    private JLabel colourLabel4;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel10;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextArea jTextArea1;
    private JTextArea previewField;
    private JCheckBox renderCheck;
    private JSpinner spinner1;
    private JSpinner spinner2;
    private JSpinner spinner3;
    private JSpinner spinner4;
    private JSpinner spinner5;
    private JSpinner spinner6;
    private JLabel spinnerLabel1;
    private JLabel spinnerLabel2;
    private JLabel spinnerLabel3;
    private JLabel spinnerLabel4;
    private JLabel spinnerLabel5;
    private JLabel spinnerLabel6;
    private JLabel styleLabel;
    private JComboBox<String> styleSelector;
    private JTextField textField1;
    private JTextField textField2;
    private JLabel textLabel1;
    private JLabel textLabel2;
    private JLabel vertAlignLabel;
    private JComboBox<String> vertAlignSelector;

    public MDTagDialog(Frame parent, TagType type) {
        super(parent, true);
        this.type = type;
        this.initComponents();
        this.setTitle("Create " + type.name().toLowerCase() + " Tag");
        switch (type) {
            case RECIPE: {
                this.setColour1("border_colour:");
                this.colourField1.setText("-1");
                this.setColour2("border_colour_hover:");
                this.colourField2.setText("-1");
                this.setText1("Stack String:");
                this.setSpinner1("padding:");
                this.spinner1.setToolTipText("Sets uniform padding around the recipe");
                this.setSpinner2("top_pad:");
                this.setSpinner3("left_pad:");
                this.setSpinner4("spacing:");
                this.spinner4.setValue(4);
                this.setSpinner5("bottom_pad:");
                this.setSpinner6("right_pad:");
                break;
            }
            case LINK: {
                this.setColour1("colour:");
                this.setColour2("colour_hover:");
                this.setColour3("border_colour:");
                this.colourField3.setToolTipText("Used only for solid button style link");
                this.setColour4("border_colour_hover:");
                this.colourField4.setToolTipText("Used only for solid button style link");
                this.setText1("Link Target");
                this.textField1.setToolTipText("<html>This target can ether be a web link e.g. http://google.com or a link to another page e.g. draconicevolution:fusionCrafting<br>You can get the address of a page by right clicking it in the page tree.</html>");
                this.setText2("alt_text");
                this.textField2.setToolTipText("If specified this is the text that will be displayed in place of the link text");
                this.setSpinner1("padding:");
                this.setSpinner2("top_pad:");
                this.setSpinner3("left_pad:");
                this.setSpinner5("bottom_pad:");
                this.setSpinner6("right_pad:");
                this.setStyle("render:");
                break;
            }
            case RULE: {
                this.setColour1("colour:");
                this.setText1("width:");
                this.textField1.setText("100%");
                this.textField1.setToolTipText("This field accepts ether a fixed width or a percentage, thats a percentage of the screen width");
                this.setSpinner1("height:");
                this.spinner1.setValue(5);
                this.setSpinner2("top_padding:");
                this.spinner2.setToolTipText("Adds blank space above the rule");
                this.setSpinner3("bottom_padding:");
                this.spinner2.setToolTipText("Adds blank space bellow the rule");
                break;
            }
            case TABLE: {
                this.setText1("width:");
                this.textField1.setText("100%");
                this.textField1.setToolTipText("This field accepts ether a fixed width or a percentage, thats a percentage of the screen width");
                this.alignSelector.setToolTipText("Sets the alignment of the table itself. Check the table documentation for info on aligning specific columns in the table");
                this.setVertAlign("vert_align:");
                this.vertAlignSelector.setToolTipText("Sets the vertical alignment of content in cells that are taller than required for the content.");
                this.setColour1("border_colour:");
                this.colourField1.setToolTipText("Sets the colour of the table cell renderer.");
                this.setColour2("heading_colour");
                this.colourField2.setToolTipText("Sets the colour of the heading cell (if a heading cell exists)");
                this.setRender("render_cells");
                this.renderCheck.setToolTipText("Can be used to completely disable the table cell renderer. In this mode the table can be used as a layout/position tool to layout a group of elements.");
                this.setSpinner1("rows");
                this.spinner1.setValue(3);
                this.setSpinner2("columns");
                this.spinner2.setValue(3);
            }
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MDTagDialog.this.previewField.setText("");
            }
        });
        this.pack();
        this.updateOutput();
        PIGuiHelper.centerWindowOn(this, parent);
    }

    public void setStack(String stack) {
        this.textField1.setText(stack);
        this.updateOutput();
    }

    private void insert(ActionEvent evt) {
        this.dispose();
    }

    private void cancel(ActionEvent evt) {
        this.previewField.setText("");
        this.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextArea1 = new JTextArea();
        this.spinnerLabel1 = new JLabel();
        this.spinner1 = new JSpinner();
        this.spinnerLabel2 = new JLabel();
        this.spinner2 = new JSpinner();
        this.spinnerLabel3 = new JLabel();
        this.spinner3 = new JSpinner();
        this.spinnerLabel5 = new JLabel();
        this.spinner5 = new JSpinner();
        this.spinnerLabel6 = new JLabel();
        this.spinner6 = new JSpinner();
        this.colourLabel2 = new JLabel();
        this.colourField2 = new JTextField();
        this.colourField1 = new JTextField();
        this.colourLabel1 = new JLabel();
        this.colourField4 = new JTextField();
        this.colourLabel4 = new JLabel();
        this.colourField3 = new JTextField();
        this.colourLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel10 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.textLabel1 = new JLabel();
        this.textField1 = new JTextField();
        this.textField2 = new JTextField();
        this.textLabel2 = new JLabel();
        this.styleSelector = new JComboBox();
        this.styleLabel = new JLabel();
        this.spinnerLabel4 = new JLabel();
        this.spinner4 = new JSpinner();
        this.jSeparator3 = new JSeparator();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.alignSelector = new JComboBox();
        this.alignLabel = new JLabel();
        this.vertAlignSelector = new JComboBox();
        this.vertAlignLabel = new JLabel();
        this.renderCheck = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.previewField = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(470, 0));
        this.setModal(true);
        this.setResizable(false);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(new Color(60, 63, 65));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(2);
        this.jTextArea1.setText("This dialog allows you to prefigure a markdown tag before it is added to the page.\nYou can manually edit any of these values later once the tag has been created.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setAutoscrolls(false);
        this.jTextArea1.setBorder(null);
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setOpaque(false);
        this.spinnerLabel1.setText("padding:");
        this.spinnerLabel1.setVisible(false);
        this.spinner1.setVisible(false);
        this.spinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MDTagDialog.this.spinnerChange(evt);
            }
        });
        this.spinnerLabel2.setText("top_pad:");
        this.spinnerLabel2.setVisible(false);
        this.spinner2.setVisible(false);
        this.spinner2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MDTagDialog.this.spinnerChange(evt);
            }
        });
        this.spinnerLabel3.setText("left_pad:");
        this.spinnerLabel3.setVisible(false);
        this.spinner3.setVisible(false);
        this.spinner3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MDTagDialog.this.spinnerChange(evt);
            }
        });
        this.spinnerLabel5.setText("bottom_pad:");
        this.spinnerLabel5.setVisible(false);
        this.spinner5.setVisible(false);
        this.spinner5.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MDTagDialog.this.spinnerChange(evt);
            }
        });
        this.spinnerLabel6.setText("right_pad:");
        this.spinnerLabel6.setVisible(false);
        this.spinner6.setVisible(false);
        this.spinner6.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MDTagDialog.this.spinnerChange(evt);
            }
        });
        this.colourLabel2.setText("colour2");
        this.colourLabel2.setVisible(false);
        this.colourField2.setVisible(false);
        this.colourField2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MDTagDialog.this.fieldChange(evt);
            }
        });
        this.colourField1.setVisible(false);
        this.colourField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MDTagDialog.this.fieldChange(evt);
            }
        });
        this.colourLabel1.setText("colour1");
        this.colourLabel1.setVisible(false);
        this.colourField4.setVisible(false);
        this.colourField4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MDTagDialog.this.fieldChange(evt);
            }
        });
        this.colourLabel4.setText("colour3");
        this.colourLabel4.setVisible(false);
        this.colourField3.setVisible(false);
        this.colourField3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MDTagDialog.this.fieldChange(evt);
            }
        });
        this.colourLabel3.setText("colour3");
        this.colourLabel3.setVisible(false);
        this.jLabel10.setText("Tag Preview:");
        this.textLabel1.setText("Alt Text:");
        this.textLabel1.setVisible(false);
        this.textField1.setVisible(false);
        this.textField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MDTagDialog.this.fieldChange(evt);
            }
        });
        this.textField2.setVisible(false);
        this.textField2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MDTagDialog.this.fieldChange(evt);
            }
        });
        this.textLabel2.setText("Hover Text:");
        this.textLabel2.setVisible(false);
        this.styleSelector.setVisible(false);
        this.styleSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"text", "vanilla", "solid"}));
        this.styleSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MDTagDialog.this.itemChange(evt);
            }
        });
        this.styleLabel.setText("Style:");
        this.styleLabel.setVisible(false);
        this.spinnerLabel4.setText("spacing:");
        this.spinnerLabel4.setVisible(false);
        this.spinner4.setVisible(false);
        this.spinner4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MDTagDialog.this.spinnerChange(evt);
            }
        });
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MDTagDialog.this.cancel(evt);
            }
        });
        this.jButton2.setText("Insert");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MDTagDialog.this.insert(evt);
            }
        });
        this.alignSelector.setVisible(false);
        this.alignSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"left", "center", "right"}));
        this.alignSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MDTagDialog.this.itemChange(evt);
            }
        });
        this.alignLabel.setText("Align:");
        this.alignLabel.setVisible(false);
        this.vertAlignSelector.setVisible(false);
        this.vertAlignSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"top", "middle", "bottom"}));
        this.vertAlignSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MDTagDialog.this.itemChange(evt);
            }
        });
        this.vertAlignLabel.setText("Vert Align:");
        this.vertAlignLabel.setVisible(false);
        this.renderCheck.setSelected(true);
        this.renderCheck.setText("render");
        this.renderCheck.setVisible(false);
        this.previewField.setColumns(20);
        this.previewField.setRows(5);
        this.previewField.setText("test");
        this.jScrollPane1.setViewportView(this.previewField);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextArea1).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinnerLabel1).addComponent(this.spinnerLabel4)).addGap(22, 22, 22).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinner4, -2, 49, -2).addComponent(this.spinner1, -2, 49, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinnerLabel2).addComponent(this.spinnerLabel5)).addGap(22, 22, 22).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinner2, -2, 49, -2).addComponent(this.spinner5, -2, 49, -2)).addGap(30, 30, 30).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinnerLabel6).addComponent(this.spinnerLabel3)).addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spinner6, -2, 49, -2).addComponent(this.spinner3, -2, 49, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colourLabel1).addComponent(this.colourLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colourField1, -2, 100, -2).addComponent(this.colourField3, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colourLabel4).addComponent(this.colourLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colourField2, -2, 100, -2).addComponent(this.colourField4, -2, 100, -2)).addGap(8, 8, 8)).addComponent(this.jSeparator2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textLabel2).addComponent(this.textLabel1)).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textField1).addComponent(this.textField2))).addComponent(this.jSeparator3).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton2).addGap(18, 18, 18).addComponent(this.jButton1)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.styleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.styleSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.alignLabel).addGap(5, 5, 5).addComponent(this.alignSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.vertAlignLabel).addGap(5, 5, 5).addComponent(this.vertAlignSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.renderCheck).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextArea1, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colourLabel1).addComponent(this.colourField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colourLabel3).addComponent(this.colourField3, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colourLabel2).addComponent(this.colourField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colourLabel4).addComponent(this.colourField4, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 4, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinnerLabel2).addComponent(this.spinner2, -2, -1, -2).addComponent(this.spinnerLabel3).addComponent(this.spinner3, -2, -1, -2).addComponent(this.spinnerLabel1).addComponent(this.spinner1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spinnerLabel5).addComponent(this.spinner5, -2, -1, -2).addComponent(this.spinnerLabel6).addComponent(this.spinner6, -2, -1, -2).addComponent(this.spinnerLabel4).addComponent(this.spinner4, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textLabel1).addComponent(this.textField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textLabel2).addComponent(this.textField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vertAlignSelector, -2, -1, -2).addComponent(this.vertAlignLabel).addComponent(this.renderCheck)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.alignSelector, -2, -1, -2).addComponent(this.alignLabel)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.styleSelector, -2, -1, -2).addComponent(this.styleLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 103, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel10).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.setBounds(0, 0, 486, 484);
    }

    private void updateOutput() {
        StringBuilder tag = new StringBuilder();
        String value = "";
        String options = "";
        String colour1 = this.colourField1.getText();
        String colour2 = this.colourField2.getText();
        String colour3 = this.colourField3.getText();
        String colour4 = this.colourField4.getText();
        int p1 = (Integer)this.spinner1.getValue();
        int p2 = (Integer)this.spinner2.getValue();
        int p3 = (Integer)this.spinner3.getValue();
        int p4 = (Integer)this.spinner4.getValue();
        int p5 = (Integer)this.spinner5.getValue();
        int p6 = (Integer)this.spinner6.getValue();
        switch (this.type) {
            case RECIPE: {
                tag = new StringBuilder("\u00a7recipe");
                value = this.textField1.getText();
                options = this.addIf(options, "border_colour:" + colour1, () -> !colour1.equals("-1") && !colour1.isEmpty());
                options = this.addIf(options, "border_colour_hover:" + colour2, () -> !colour2.equals("-1") && !colour2.isEmpty());
                options = this.addIf(options, "padding:" + p1, () -> p1 > 0);
                options = this.addIf(options, "top_pad:" + p2, () -> p2 > 0);
                options = this.addIf(options, "left_pad:" + p3, () -> p3 > 0);
                options = this.addIf(options, "spacing:" + p4, () -> p4 > 0);
                options = this.addIf(options, "bottom_pad:" + p5, () -> p5 > 0);
                options = this.addIf(options, "right_pad:" + p6, () -> p6 > 0);
                break;
            }
            case LINK: {
                tag = new StringBuilder("\u00a7link");
                value = this.textField1.getText();
                options = this.addIf(options, "alt_text:\"" + this.textField2.getText() + "\"", () -> !this.textField2.getText().isEmpty());
                options = this.addIf(options, "border_colour:" + colour3, () -> !colour3.equals("-1") && !colour3.isEmpty());
                options = this.addIf(options, "border_colour_hover:" + colour4, () -> !colour4.equals("-1") && !colour4.isEmpty());
                options = this.addIf(options, "colour:" + colour1, () -> !colour1.equals("-1") && !colour1.isEmpty());
                options = this.addIf(options, "colour_hover:" + colour2, () -> !colour2.equals("-1") && !colour2.isEmpty());
                options = this.addIf(options, "padding:" + p1, () -> p1 > 0);
                options = this.addIf(options, "top_pad:" + p2, () -> p2 > 0);
                options = this.addIf(options, "left_pad:" + p3, () -> p3 > 0);
                options = this.addIf(options, "bottom_pad:" + p5, () -> p5 > 0);
                options = this.addIf(options, "right_pad:" + p6, () -> p6 > 0);
                options = this.addIf(options, "link_style:" + this.styleSelector.getSelectedItem(), () -> !this.styleSelector.getSelectedItem().equals("text"));
                break;
            }
            case RULE: {
                tag = new StringBuilder("\u00a7rule");
                options = this.addIf(options, "colour:" + colour1, () -> !colour1.equals("-1") && !colour1.isEmpty());
                options = this.addIf(options, "height:" + p1, () -> p1 > 0);
                options = this.addIf(options, "top_pad:" + p2, () -> p2 > 0);
                options = this.addIf(options, "bottom_pad:" + p3, () -> p3 > 0);
                options = this.addIf(options, "width:" + this.textField1.getText(), () -> true);
                options = this.addIf(options, "align:" + this.alignSelector.getSelectedItem(), () -> !this.alignSelector.getSelectedItem().equals("left"));
                this.previewField.setText(tag + "{" + options + "}");
                return;
            }
            case TABLE: {
                options = this.addIf(options, "border_colour:" + colour1, () -> !colour1.equals("-1") && !colour1.isEmpty());
                options = this.addIf(options, "heading_colour:" + colour2, () -> !colour2.equals("-1") && !colour2.isEmpty());
                options = this.addIf(options, "width:" + this.textField1.getText(), () -> true);
                options = this.addIf(options, "vert_align:" + this.vertAlignSelector.getSelectedItem(), () -> !this.vertAlignSelector.getSelectedItem().equals("top"));
                tag = new StringBuilder("\u00a7table[" + options + "]");
                int rows = Math.max(1, (Integer)this.spinner1.getValue());
                int columns = Math.max(1, (Integer)this.spinner2.getValue());
                for (int i = 0; i < rows + 1; ++i) {
                    StringBuilder r = new StringBuilder("|");
                    for (int c = 0; c < columns; ++c) {
                        if (i == 0) {
                            r.append(" Heading ").append(c).append(" |");
                            continue;
                        }
                        if (i == 1) {
                            r.append(" :-------------------- |");
                            continue;
                        }
                        r.append(" <Row ").append(i).append(", Column ").append(c).append("> |");
                    }
                    tag.append("\n").append((CharSequence)r);
                }
                this.previewField.setText(tag.toString());
                return;
            }
        }
        this.previewField.setText(tag + "[" + (value.isEmpty() ? "" : value) + "]" + (options.isEmpty() ? "" : "{" + options + "}"));
    }

    private void fieldChange(KeyEvent evt) {
        this.updateOutput();
    }

    private void spinnerChange(ChangeEvent evt) {
        this.updateOutput();
    }

    private void itemChange(ItemEvent evt) {
        if (this.type == TagType.LINK && evt.getSource() == this.styleSelector && this.styleSelector.getSelectedItem() != null) {
            if (this.styleSelector.getSelectedItem().equals("vanilla")) {
                this.colourField1.setText("0xE0E0E0");
                this.colourField2.setText("0xFFFFA0");
                this.colourField3.setText("-1");
                this.colourField4.setText("-1");
            } else if (this.styleSelector.getSelectedItem().equals("text")) {
                this.colourField1.setText("0x4444FF");
                this.colourField2.setText("0xFF69B4");
                this.colourField3.setText("-1");
                this.colourField4.setText("-1");
            } else {
                this.colourField1.setText("0x303030");
                this.colourField2.setText("0x303030");
                this.colourField3.setText("0xFFFFFF");
                this.colourField4.setText("0x00FF00");
            }
        }
        this.updateOutput();
    }

    public String getTag() {
        return this.previewField.getText();
    }

    private void setColour1(@Nullable String name) {
        this.colourField1.setVisible(name != null);
        this.colourLabel1.setVisible(name != null);
        this.colourLabel1.setText(String.valueOf(name));
    }

    private void setColour2(@Nullable String name) {
        this.colourField2.setVisible(name != null);
        this.colourLabel2.setVisible(name != null);
        this.colourLabel2.setText(String.valueOf(name));
    }

    private void setColour3(@Nullable String name) {
        this.colourField3.setVisible(name != null);
        this.colourLabel3.setVisible(name != null);
        this.colourLabel3.setText(String.valueOf(name));
    }

    private void setColour4(@Nullable String name) {
        this.colourField4.setVisible(name != null);
        this.colourLabel4.setVisible(name != null);
        this.colourLabel4.setText(String.valueOf(name));
    }

    private void setSpinner1(@Nullable String name) {
        this.spinner1.setVisible(name != null);
        this.spinnerLabel1.setVisible(name != null);
        this.spinnerLabel1.setText(String.valueOf(name));
    }

    private void setSpinner2(@Nullable String name) {
        this.spinner2.setVisible(name != null);
        this.spinnerLabel2.setVisible(name != null);
        this.spinnerLabel2.setText(String.valueOf(name));
    }

    private void setSpinner3(@Nullable String name) {
        this.spinner3.setVisible(name != null);
        this.spinnerLabel3.setVisible(name != null);
        this.spinnerLabel3.setText(String.valueOf(name));
    }

    private void setSpinner4(@Nullable String name) {
        this.spinner4.setVisible(name != null);
        this.spinnerLabel4.setVisible(name != null);
        this.spinnerLabel4.setText(String.valueOf(name));
    }

    private void setSpinner5(@Nullable String name) {
        this.spinner5.setVisible(name != null);
        this.spinnerLabel5.setVisible(name != null);
        this.spinnerLabel5.setText(String.valueOf(name));
    }

    private void setSpinner6(@Nullable String name) {
        this.spinner6.setVisible(name != null);
        this.spinnerLabel6.setVisible(name != null);
        this.spinnerLabel6.setText(String.valueOf(name));
    }

    private void setText1(@Nullable String name) {
        this.textField1.setVisible(name != null);
        this.textLabel1.setVisible(name != null);
        this.textLabel1.setText(String.valueOf(name));
    }

    private void setText2(@Nullable String name) {
        this.textField2.setVisible(name != null);
        this.textLabel2.setVisible(name != null);
        this.textLabel2.setText(String.valueOf(name));
    }

    private void setStyle(@Nullable String name) {
        this.styleSelector.setVisible(name != null);
        this.styleLabel.setVisible(name != null);
        this.styleLabel.setText(String.valueOf(name));
    }

    private void setAlign(@Nullable String name) {
        this.alignSelector.setVisible(name != null);
        this.alignLabel.setVisible(name != null);
        this.alignLabel.setText(String.valueOf(name));
    }

    private void setVertAlign(@Nullable String name) {
        this.vertAlignSelector.setVisible(name != null);
        this.vertAlignLabel.setVisible(name != null);
        this.vertAlignLabel.setText(String.valueOf(name));
    }

    private void setRender(@Nullable String name) {
        this.renderCheck.setVisible(name != null);
    }

    private String addIf(String ops, Object add, Supplier<Boolean> check) {
        return ops + (check.get() != false ? (ops.isEmpty() ? "" : ",") + add : "");
    }

    public static enum TagType {
        RECIPE,
        LINK,
        RULE,
        TABLE;

    }
}

