/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.projectintelligence.client.gui;

import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.lib.DLRSCache;
import com.brandon3055.projectintelligence.api.PiAPI;
import com.brandon3055.projectintelligence.client.DisplayController;
import com.brandon3055.projectintelligence.client.PIGuiHelper;
import com.brandon3055.projectintelligence.client.gui.GuiProjectIntelligence;
import com.brandon3055.projectintelligence.client.gui.guielements.GuiPartMenu;
import com.brandon3055.projectintelligence.docmanagement.DocumentationManager;
import com.brandon3055.projectintelligence.utils.LogHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PIConfig {
    public static File configFile;
    private static boolean editMode;
    public static volatile String editingRepoLoc;
    public static int screenMode;
    public static boolean screenPosOverride;
    public static int screenPosX;
    public static int screenPosY;
    public static boolean etCheckFluid;
    public static volatile boolean editorAlwaysOnTop;
    public static volatile boolean editorLineWrap;
    public static Map<String, String> modVersionOverrides;
    public static int maxTabs;
    public static volatile String editorLAF;
    public static String userLanguage;
    public static Map<String, String> pageLangOverrides;
    public static Map<String, String> modLangOverrides;
    public static SearchMode searchMode;
    public static boolean tutorialDisplayed;
    public static boolean downloadsAllowed;
    public static boolean showTutorialLater;
    public static String homePage;

    public static void initialize() {
        File piFolder = new File(FileHandler.brandon3055Folder, "ProjectIntelligence");
        configFile = new File(piFolder, "GuiConfig.json");
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            PIConfig.save();
        }
        PIConfig.load();
    }

    public static synchronized void save() {
        JsonObject jObj = new JsonObject();
        jObj.addProperty("downloadsAllowed", Boolean.valueOf(downloadsAllowed));
        jObj.addProperty("tutorialDisplayed", Boolean.valueOf(tutorialDisplayed));
        jObj.addProperty("editMode", Boolean.valueOf(editMode));
        jObj.addProperty("etCheckFluid", Boolean.valueOf(etCheckFluid));
        jObj.addProperty("editingRepoLoc", editingRepoLoc);
        jObj.addProperty("editorAlwaysOnTop", Boolean.valueOf(editorAlwaysOnTop));
        jObj.addProperty("editorLineWrap", Boolean.valueOf(editorLineWrap));
        jObj.addProperty("maxTabs", (Number)maxTabs);
        jObj.addProperty("editorLAF", editorLAF);
        jObj.addProperty("screenMode", (Number)screenMode);
        jObj.addProperty("screenPosOverride", Boolean.valueOf(screenPosOverride));
        jObj.addProperty("screenPosX", (Number)screenPosX);
        jObj.addProperty("screenPosY", (Number)screenPosY);
        jObj.addProperty("userLanguage", userLanguage);
        jObj.addProperty("homePage", homePage);
        jObj.addProperty("searchMode", searchMode.name());
        JsonObject langOverrides = new JsonObject();
        pageLangOverrides.forEach((arg_0, arg_1) -> ((JsonObject)langOverrides).addProperty(arg_0, arg_1));
        jObj.add("pageLangOverrides", (JsonElement)langOverrides);
        JsonObject modLangOverrideList = new JsonObject();
        modLangOverrides.forEach((arg_0, arg_1) -> ((JsonObject)modLangOverrideList).addProperty(arg_0, arg_1));
        jObj.add("modLangOverrides", (JsonElement)modLangOverrideList);
        JsonObject modVersionOverrideList = new JsonObject();
        modVersionOverrides.forEach((arg_0, arg_1) -> ((JsonObject)modVersionOverrideList).addProperty(arg_0, arg_1));
        jObj.add("modVersionOverrides", (JsonElement)modVersionOverrideList);
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(configFile));
            writer.setIndent("  ");
            Streams.write((JsonElement)jObj, (JsonWriter)writer);
            writer.flush();
            IOUtils.closeQuietly((Closeable)writer);
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Error saving gui config: " + e.getMessage());
            LogHelper.error("Error saving gui config");
            e.printStackTrace();
        }
    }

    public static void load() {
        JsonObject langOverrides;
        JsonObject jObj;
        try {
            JsonParser parser = new JsonParser();
            FileReader reader = new FileReader(configFile);
            JsonElement element = parser.parse((Reader)reader);
            IOUtils.closeQuietly((Reader)reader);
            if (!element.isJsonObject()) {
                PIGuiHelper.displayError("Failed to load gui config. Detected invalid config file.");
                return;
            }
            jObj = element.getAsJsonObject();
        }
        catch (Exception e) {
            PIGuiHelper.displayError("Error loading gui config: " + e.getMessage());
            LogHelper.error("Error loading gui config");
            e.printStackTrace();
            return;
        }
        downloadsAllowed = JsonUtils.func_151209_a((JsonObject)jObj, (String)"downloadsAllowed", (boolean)false);
        tutorialDisplayed = JsonUtils.func_151209_a((JsonObject)jObj, (String)"tutorialDisplayed", (boolean)false);
        editMode = JsonUtils.func_151209_a((JsonObject)jObj, (String)"editMode", (boolean)false);
        etCheckFluid = JsonUtils.func_151209_a((JsonObject)jObj, (String)"etCheckFluid", (boolean)true);
        editingRepoLoc = JsonUtils.func_151219_a((JsonObject)jObj, (String)"editingRepoLoc", (String)"");
        editorAlwaysOnTop = JsonUtils.func_151209_a((JsonObject)jObj, (String)"editorAlwaysOnTop", (boolean)false);
        editorLineWrap = JsonUtils.func_151209_a((JsonObject)jObj, (String)"editorLineWrap", (boolean)true);
        maxTabs = JsonUtils.func_151208_a((JsonObject)jObj, (String)"maxTabs", (int)16);
        editorLAF = JsonUtils.func_151219_a((JsonObject)jObj, (String)"editorLAF", (String)"");
        screenMode = JsonUtils.func_151208_a((JsonObject)jObj, (String)"screenMode", (int)screenMode);
        screenPosOverride = JsonUtils.func_151209_a((JsonObject)jObj, (String)"screenPosOverride", (boolean)false);
        screenPosX = JsonUtils.func_151208_a((JsonObject)jObj, (String)"screenPosX", (int)0);
        screenPosY = JsonUtils.func_151208_a((JsonObject)jObj, (String)"screenPosY", (int)0);
        userLanguage = JsonUtils.func_151219_a((JsonObject)jObj, (String)"userLanguage", (String)"[MINECRAFT-LANG]");
        homePage = JsonUtils.func_151219_a((JsonObject)jObj, (String)"homePage", (String)"projectintelligence:");
        try {
            searchMode = SearchMode.valueOf(JsonUtils.func_151219_a((JsonObject)jObj, (String)"searchMode", (String)SearchMode.EVERYWHERE.name()));
        }
        catch (Exception e) {
            LogHelper.error("Detected invalid search mode in PI Config! Default mode will be used.");
            e.printStackTrace();
        }
        pageLangOverrides.clear();
        if (jObj.has("pageLangOverrides") && jObj.get("pageLangOverrides").isJsonObject()) {
            langOverrides = JsonUtils.func_152754_s((JsonObject)jObj, (String)"pageLangOverrides");
            langOverrides.entrySet().forEach(entry -> pageLangOverrides.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()));
        }
        modLangOverrides.clear();
        if (jObj.has("modLangOverrides") && jObj.get("modLangOverrides").isJsonObject()) {
            langOverrides = JsonUtils.func_152754_s((JsonObject)jObj, (String)"modLangOverrides");
            langOverrides.entrySet().forEach(entry -> modLangOverrides.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()));
        }
        modVersionOverrides.clear();
        if (jObj.has("modVersionOverrides") && jObj.get("modVersionOverrides").isJsonObject()) {
            JsonObject versionOverrides = JsonUtils.func_152754_s((JsonObject)jObj, (String)"modVersionOverrides");
            versionOverrides.entrySet().forEach(entry -> modVersionOverrides.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString()));
        }
    }

    public static void setHomePage(String homePage) {
        PIConfig.homePage = homePage;
        PIConfig.save();
    }

    public static void setEditMode(boolean editMode) {
        PIConfig.editMode = editMode;
        GuiPartMenu menu = GuiProjectIntelligence.getMenuPart();
        if (menu != null && menu.configUI != null) {
            menu.configUI.reloadConfigProperties();
        }
    }

    public static synchronized boolean editMode() {
        return editMode;
    }

    public static void deleteConfigAndReload() {
        File piFolder = new File(FileHandler.brandon3055Folder, "ProjectIntelligence");
        try {
            FileUtils.deleteDirectory((File)piFolder);
            DocumentationManager.clear();
            editMode = false;
            editingRepoLoc = "";
            screenMode = 0;
            screenPosOverride = false;
            screenPosX = 0;
            screenPosY = 0;
            etCheckFluid = true;
            editorAlwaysOnTop = false;
            editorLineWrap = false;
            modVersionOverrides = new HashMap<String, String>();
            maxTabs = 16;
            editorLAF = "";
            userLanguage = "[MINECRAFT-LANG]";
            pageLangOverrides = new HashMap<String, String>();
            modLangOverrides = new HashMap<String, String>();
            searchMode = SearchMode.EVERYWHERE;
            tutorialDisplayed = false;
            downloadsAllowed = false;
            showTutorialLater = false;
            PIConfig.initialize();
            DocumentationManager.initialize();
            DisplayController.MASTER_CONTROLLER.clear();
            DLRSCache.clearFileCache();
            PiAPI.openGui(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            PIGuiHelper.displayError(e.getMessage());
        }
    }

    static {
        editMode = false;
        editingRepoLoc = "";
        screenMode = 0;
        screenPosOverride = false;
        screenPosX = 0;
        screenPosY = 0;
        etCheckFluid = true;
        editorAlwaysOnTop = false;
        editorLineWrap = false;
        modVersionOverrides = new HashMap<String, String>();
        maxTabs = 16;
        editorLAF = "";
        userLanguage = "[MINECRAFT-LANG]";
        pageLangOverrides = new HashMap<String, String>();
        modLangOverrides = new HashMap<String, String>();
        searchMode = SearchMode.EVERYWHERE;
        tutorialDisplayed = false;
        downloadsAllowed = false;
        showTutorialLater = false;
        homePage = "projectintelligence:";
    }

    public static enum SearchMode {
        EVERYWHERE,
        SELECTED_MOD,
        PAGE_SUB_PAGES,
        PAGE_ONLY;


        public String getUnlocalizedName() {
            return "pi.search.mode." + this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

