/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.world;

import com.google.common.collect.ImmutableMap;
import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.config.Cfg;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class VariantFeature
extends WorldGenerator {
    private static final double DENSE_CHANCE = Cfg.DenseCat.enabled ? Cfg.DenseCat.chance : 0.0;
    private final ImmutableMap<IBlockState, IBlockState> genMap;
    private final float count;
    private final double count16;
    private final float count8;

    public VariantFeature(Map<IBlockState, IBlockState> genMap, int count) {
        this.genMap = ImmutableMap.copyOf(genMap);
        this.count = count;
        this.count16 = (double)count / 16.0;
        this.count8 = (float)count / 8.0f;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        return this.count < 4.0f ? this.smallFeature(world, rand, pos) : this.genFeature(world, rand, pos);
    }

    private boolean smallFeature(World world, Random rand, BlockPos pos) {
        BlockPos offset = pos.func_177982_a(8, 0, 8);
        int i = 1;
        while ((float)i < this.count) {
            int x = rand.nextInt(2);
            int y = rand.nextInt(2);
            int z = rand.nextInt(2);
            BlockPos newPos = offset.func_177982_a(x, y, z);
            this.trySet(newPos, rand, world);
            ++i;
        }
        return true;
    }

    public boolean genFeature(World world, Random rand, BlockPos pos) {
        float f = rand.nextFloat() * (float)Math.PI;
        float sinFCount = MathHelper.func_76126_a((float)f) * this.count8;
        float cosFCount = MathHelper.func_76134_b((float)f) * this.count8;
        double d0 = (float)(pos.func_177958_n() + 8) + sinFCount;
        double d2 = (float)(pos.func_177952_p() + 8) + cosFCount;
        double d4Rand = rand.nextInt(3);
        double d4 = (double)(pos.func_177956_o() - 2) + d4Rand;
        double d1Md0Dc = -2.0 * (double)sinFCount / (double)this.count;
        double d5Md4DC = ((double)rand.nextInt(3) - d4Rand) / (double)this.count;
        double d3Md2Dc = -2.0 * (double)cosFCount / (double)this.count;
        int i = 0;
        while ((float)i < this.count) {
            double d6 = d0 + d1Md0Dc * (double)i;
            double d7 = d4 + d5Md4DC * (double)i;
            double d8 = d2 + d3Md2Dc * (double)i;
            double d10 = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * (float)i / this.count)) + 1.0f) * (rand.nextDouble() * this.count16) + 1.0) / 2.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10));
            int k = MathHelper.func_76128_c((double)(d7 - d10));
            int l = MathHelper.func_76128_c((double)(d8 - d10));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10));
            int j1 = MathHelper.func_76128_c((double)(d7 + d10));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10));
            double d6Shift = 0.5 - d6;
            double d7Shift = 0.5 - d7;
            double d8Shift = 0.5 - d8;
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + d6Shift) / d10;
                double d12Square = d12 * d12;
                if (!(d12Square < 1.0)) continue;
                double d13Max = 1.0 - d12Square;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + d7Shift) / d10;
                    double d13Square = d13 * d13;
                    if (!(d13Square < d13Max)) continue;
                    double d14Max = d13Max - d13Square;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        double d14 = ((double)j2 + d8Shift) / d10;
                        double d14Square = d14 * d14;
                        if (!(d14Square < d14Max)) continue;
                        BlockPos newPos = new BlockPos(l1, i2, j2);
                        this.trySet(newPos, rand, world);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private void trySet(BlockPos pos, Random rand, World world) {
        IBlockState found = world.func_180495_p(pos);
        IBlockState candidate = (IBlockState)this.genMap.get((Object)found);
        if (candidate != null) {
            if (rand.nextDouble() <= DENSE_CHANCE) {
                candidate = candidate.func_177226_a((IProperty)BaseOreVariant.DENSE, (Comparable)Boolean.valueOf(true));
            }
            world.func_180501_a(pos, candidate, 2);
        }
    }
}

