/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.world;

import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.util.HashGenerator;

public class RandomChunkSelector {
    private final HashGenerator noise;
    private static final double SELECTION_THRESHOLD = 91.0;
    private static final double MAX_PROBABILITY = Cfg.WorldCat.largeClusterMaxProbability;
    private static final double DEFAULT_PROBABILITY = Cfg.WorldCat.largeClusterDefaultProbability;
    private static final int DISTANCE = 2;

    public RandomChunkSelector(long worldSeed) {
        this.noise = new HashGenerator(worldSeed);
    }

    public boolean testCoordinates(int ID, int x, int y) {
        return this.noise.getHash(ID, x, y) > 91.0;
    }

    public double getProbability(int ID, int x, int y) {
        if (this.testCoordinates(ID, x, y)) {
            return MAX_PROBABILITY;
        }
        for (int i = 1; i <= 2; ++i) {
            if (!this.testDistance(ID, x, y, i)) continue;
            return (int)MAX_PROBABILITY >> i;
        }
        return DEFAULT_PROBABILITY;
    }

    private boolean testDistance(int ID, int x, int y, int radius) {
        int diameter = radius * 2 + 1;
        int innerLength = diameter - 2;
        int shift = -(radius - 1);
        if (this.testCoordinates(ID, x + radius, y + radius) || this.testCoordinates(ID, x - radius, y - radius) || this.testCoordinates(ID, x + radius, y - radius) || this.testCoordinates(ID, x - radius, y + radius)) {
            return true;
        }
        for (int i = shift; i < innerLength + shift; ++i) {
            if (!this.testCoordinates(ID, x + radius, y + i) && !this.testCoordinates(ID, x + i, y + radius) && !this.testCoordinates(ID, x - radius, y + i) && !this.testCoordinates(ID, x + i, y - radius)) continue;
            return true;
        }
        return false;
    }
}

