/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.world;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.Lazy;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.init.Blocks;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class DisableVanillaGen {
    private static final Lazy<Boolean> NETHER_QUARTZ_EXISTS = new Lazy<Supplier<Boolean>>(() -> CommonMethods.find(Main.BLOCKS, DisableVanillaGen::isNetherQuartz).isPresent());
    private static final List<OreGenEvent.GenerateMinable.EventType> VANILLA_ORES = CommonMethods.list(OreGenEvent.GenerateMinable.EventType.COAL, OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.EMERALD);
    private static final List<OreGenEvent.GenerateMinable.EventType> VANILLA_STONE = CommonMethods.list(OreGenEvent.GenerateMinable.EventType.DIRT, OreGenEvent.GenerateMinable.EventType.GRAVEL, OreGenEvent.GenerateMinable.EventType.DIORITE, OreGenEvent.GenerateMinable.EventType.GRANITE, OreGenEvent.GenerateMinable.EventType.ANDESITE);

    @SubscribeEvent
    public static void disableGen(OreGenEvent.GenerateMinable event) {
        boolean enableStone = Cfg.WorldCat.enableVanillaStone;
        boolean enableOres = Cfg.WorldCat.enableVanillaOres;
        OreGenEvent.GenerateMinable.EventType type = event.getType();
        if (!enableOres && VANILLA_ORES.contains(type)) {
            event.setResult(Event.Result.DENY);
        } else if (!enableStone && VANILLA_STONE.contains(type)) {
            event.setResult(Event.Result.DENY);
        } else if (type.equals((Object)OreGenEvent.GenerateMinable.EventType.QUARTZ) && NETHER_QUARTZ_EXISTS.get().booleanValue()) {
            event.setResult(Event.Result.DENY);
        } else if (type.equals((Object)OreGenEvent.GenerateMinable.EventType.CUSTOM) && !CommonMethods.isModLoaded("undergroundbiomes")) {
            event.setResult(Event.Result.DENY);
        }
    }

    private static boolean isNetherQuartz(BaseOreVariant ore) {
        return ore.bgBlock.equals(Blocks.field_150424_aL.func_176223_P()) && ore.properties.ore.get().equals(Blocks.field_150449_bY.func_176223_P());
    }
}

