/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util.unsafe;

import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.unsafe.Result;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ReflectionTools {
    public static Field getField(Class clazz, String name) {
        Field f = Result.of(() -> ReflectionHelper.findField((Class)clazz, (String[])new String[]{name})).expect("Build error: invalid field name used in reflection.");
        f.setAccessible(true);
        return f;
    }

    public static Field getField(Class clazz, String name, String obfName, int index) {
        Field f = Result.of(() -> ReflectionHelper.findField((Class)clazz, (String)name, (String)obfName)).ifErr(e -> CommonMethods.debug("Reflection error: field \"{}\" not found in mappings. Trying index...", name)).orElseTry(e -> clazz.getDeclaredFields()[index]).expect("Build error: invalid field name / index used in reflection.");
        f.setAccessible(true);
        return f;
    }

    public static Method getMethod(Class clazz, String name, @Nullable String obfName, Class ... params) {
        Method method = ReflectionHelper.findMethod((Class)clazz, (String)name, (String)obfName, (Class[])params);
        method.setAccessible(true);
        return method;
    }

    public static <T> T getValue(Field f, Object instance) {
        return (T)Result.of(() -> f.get(instance)).expect("Build error: field not marked as accessible.");
    }

    public static <T> T getValue(Class clazz, String name, Object instance) {
        return ReflectionTools.getValue(ReflectionTools.getField(clazz, name), instance);
    }

    public static <T> T getValue(Class clazz, String name, String obfName, int index, Object instance) {
        return ReflectionTools.getValue(ReflectionTools.getField(clazz, name, obfName, index), instance);
    }

    public static <T> T getValue(Class clazz, String name, String obfName, Object instance) {
        return (T)Result.of(() -> ReflectionHelper.getPrivateValue((Class)clazz, (Object)instance, (String)name, (String)obfName)).expect("Build error: invalid field names used in reflection.");
    }

    public static void setValue(Field f, Object instance, Object value) {
        Result.of(() -> f.set(instance, value)).expect("Build error: field not marked as accessible.");
    }
}

