/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import com.personthecat.orestonevariants.util.CommonMethods;
import java.util.Optional;
import java.util.function.Function;

public class LazyFunction<T, R> {
    private R value = null;
    private final Function<T, R> func;

    public LazyFunction(Function<T, R> func) {
        this.func = func;
    }

    public LazyFunction(R value) {
        this.value = value;
        this.func = r -> null;
    }

    public R apply(T t) {
        if (this.value == null) {
            this.value = this.func.apply(t);
            if (this.value == null) {
                throw new NullPointerException("Lazy value produced nothing.");
            }
        }
        return this.value;
    }

    public Optional<R> getIfComputed() {
        return CommonMethods.nullable(this.value);
    }

    public boolean computed() {
        return this.value != null;
    }
}

