/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import com.personthecat.orestonevariants.util.CommonMethods;
import java.util.Optional;
import java.util.function.Supplier;

public class Lazy<T> {
    private T value = null;
    private final Supplier<T> supplier;

    public Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public Lazy(T value) {
        this.value = value;
        this.supplier = () -> null;
    }

    public T get() {
        if (this.value == null) {
            this.value = this.supplier.get();
            if (this.value == null) {
                throw new NullPointerException("Lazy value produced nothing.");
            }
        }
        return this.value;
    }

    public Optional<T> getIfComputed() {
        return CommonMethods.nullable(this.value);
    }

    public boolean computed() {
        return this.value != null;
    }
}

