/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class DualMap<K1, K2, V> {
    private final Map<K1, Map<K2, V>> map;

    private DualMap(Map<K1, Map<K2, V>> map) {
        this.map = map;
    }

    @Nullable
    public V get(K1 k1, K2 k2) {
        Map<K2, V> k2Get = this.map.get(k1);
        if (k2Get != null) {
            return k2Get.get(k2);
        }
        return null;
    }

    public static class Builder<K1, K2, V> {
        private final Map<K1, Map<K2, V>> map = new HashMap<K1, Map<K2, V>>();

        public Builder put(K1 k1, K2 k2, V v) {
            this.map.putIfAbsent(k1, new HashMap());
            this.map.get(k1).put(k2, v);
            return this;
        }

        public boolean has(K1 k1, K2 k2) {
            return this.map.containsKey(k1) && this.map.get(k1).containsKey(k2);
        }

        public V get(K1 k1, K2 k2) {
            return this.map.get(k1).get(k2);
        }

        public DualMap<K1, K2, V> build() {
            HashMap<K1, ImmutableMap> immutable = new HashMap<K1, ImmutableMap>();
            for (Map.Entry<K1, Map<K2, V>> entry : this.map.entrySet()) {
                immutable.put(entry.getKey(), ImmutableMap.copyOf(entry.getValue()));
            }
            return new DualMap((Map)ImmutableMap.copyOf(immutable));
        }
    }
}

