/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.util;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.util.ExtendedResourceLocation;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonMethods {
    public static void println(String x) {
        System.out.println(x);
    }

    public static void info(String x, Object ... args) {
        Main.LOGGER.info(x, args);
    }

    public static void debug(String x, Object ... args) {
        Main.LOGGER.debug(x, args);
    }

    public static void warn(String x, Object ... args) {
        Main.LOGGER.warn(x, args);
    }

    public static void error(String x, Object ... args) {
        Main.LOGGER.error(x, args);
    }

    public static void fatal(String x, Object ... args) {
        Main.LOGGER.fatal(x, args);
    }

    public static void log(Level level, String x, Object ... args) {
        if (level.equals((Object)Level.FATAL)) {
            throw CommonMethods.runExF(x, args);
        }
        Main.LOGGER.log(level, x, args);
    }

    public static RuntimeException runEx(String x) {
        return new RuntimeException(x);
    }

    public static RuntimeException runEx(Throwable e) {
        return new RuntimeException(e);
    }

    public static RuntimeException runEx(String x, Throwable e) {
        return new RuntimeException(x, e);
    }

    public static RuntimeException runExF(String x, Object ... args) {
        return new RuntimeException(CommonMethods.f(x, args));
    }

    public static <T> Optional<T> find(T[] values, Predicate<T> by) {
        for (T val : values) {
            if (!by.test(val)) continue;
            return CommonMethods.full(val);
        }
        return CommonMethods.empty();
    }

    public static <T> Optional<T> find(Collection<T> values, Predicate<T> by) {
        for (T val : values) {
            if (!by.test(val)) continue;
            return CommonMethods.full(val);
        }
        return CommonMethods.empty();
    }

    public static <T> List<T> findAll(Collection<T> values, Predicate<T> by) {
        ArrayList<T> list = new ArrayList<T>();
        for (T val : values) {
            if (!by.test(val)) continue;
            list.add(val);
        }
        return list;
    }

    public static <T> boolean anyMatches(Collection<T> values, Predicate<T> by) {
        for (T val : values) {
            if (!by.test(val)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean anyMatches(T[] values, Predicate<T> by) {
        for (T val : values) {
            if (!by.test(val)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] toArray(List<T> list, Class<T> clazz) {
        return list.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public static <K, V> Optional<V> safeGet(Map<K, V> map, K key) {
        return Optional.ofNullable(map.get(key));
    }

    public static <T> Optional<T> safeGet(T[] array, int index) {
        return index >= 0 && index < array.length ? CommonMethods.full(array[index]) : CommonMethods.empty();
    }

    public static <K, V> Optional<V> biLookup(Map<K, V> map, BiPredicate<K, V> by) {
        return map.entrySet().stream().filter(e -> by.test(e.getKey(), e.getValue())).findFirst().map(Map.Entry::getValue);
    }

    public static <T> ArrayList<T> cloneList(ArrayList<T> list) {
        return (ArrayList)list.clone();
    }

    public static <T> List<T> list(T ... values) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, values);
        return list;
    }

    public static String extension(File file) {
        String name = file.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static String noExtension(File file) {
        String name = file.getName();
        return name.substring(0, name.indexOf("."));
    }

    public static boolean startsWithAny(String s, String ... match) {
        for (String s2 : match) {
            if (!s.startsWith(s2)) continue;
            return true;
        }
        return false;
    }

    public static String f(String s, Object ... args) {
        int begin = 0;
        int si = 0;
        int oi = 0;
        StringBuilder sb = new StringBuilder();
        while ((si = s.indexOf("{}", si)) >= 0) {
            sb.append(s.substring(begin, si));
            sb.append(args[oi++]);
            begin = si += 2;
        }
        sb.append(s.substring(begin));
        return sb.toString();
    }

    public static Logger logger(String name) {
        return LogManager.getLogger((String)name);
    }

    public static <T> Optional<T> empty() {
        return Optional.empty();
    }

    public static <T> Optional<T> full(T val) {
        return Optional.of(val);
    }

    public static <T> Optional<T> nullable(T val) {
        return Optional.ofNullable(val);
    }

    public static int getMin(int a, int b) {
        return a < b ? a : b;
    }

    public static int getMax(int a, int b) {
        return a > b ? a : b;
    }

    public static float getMin(float a, float b) {
        return a < b ? a : b;
    }

    public static float getMax(float a, float b) {
        return a > b ? a : b;
    }

    public static double getMin(double a, double b) {
        return a < b ? a : b;
    }

    public static double getMax(double a, double b) {
        return a > b ? a : b;
    }

    public static float avg(float a, float b) {
        return (a + b) / 2.0f;
    }

    public static int numBetween(Random rand, int min, int max) {
        return min == max ? min : rand.nextInt(max - min + 1) + min;
    }

    public static int invert(double value) {
        return value == 0.0 ? Integer.MAX_VALUE : (int)(1.0 / value);
    }

    public static int[] sort(int[] array) {
        Arrays.sort(array);
        return array;
    }

    public static boolean isModLoaded(String mod) {
        return Loader.isModLoaded((String)mod);
    }

    public static File getConfigDir() {
        return Loader.instance().getConfigDir();
    }

    public static Optional<Biome> getBiome(String biomeName) {
        return Optional.ofNullable((Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName)));
    }

    public static Biome[] getBiomes(BiomeDictionary.Type biomeType) {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType).toArray(new Biome[0]);
    }

    public static BiomeDictionary.Type getBiomeType(String name) {
        return BiomeDictionary.Type.getType((String)name, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    }

    public static ResourceLocation osvLocation(String name) {
        return new ResourceLocation("osv", name);
    }

    public static ModelResourceLocation mrl(ResourceLocation location, String id) {
        return new ModelResourceLocation(location, id);
    }

    public static boolean isBlock(String fullName) {
        return CommonMethods.isBlock(new ResourceLocation(CommonMethods.ignoreData(fullName)));
    }

    public static boolean isBlock(ResourceLocation location) {
        return ForgeRegistries.BLOCKS.containsKey(location);
    }

    public static Optional<IBlockState> getBlockState(String registryName) {
        if (registryName.equals("air") || registryName.equals("minecraft:air")) {
            return CommonMethods.full(Blocks.field_150350_a.func_176223_P());
        }
        return CommonMethods._getBlock(ExtendedResourceLocation.complete(registryName));
    }

    private static Optional<IBlockState> _getBlock(ExtendedResourceLocation registry) {
        IBlockState ret;
        ResourceLocation location = registry.strip();
        int meta = registry.getMeta();
        try {
            ret = ((Block)ForgeRegistries.BLOCKS.getValue(location)).func_176203_a(meta);
        }
        catch (NullPointerException e) {
            return CommonMethods.empty();
        }
        if (ret.equals(Blocks.field_150350_a.func_176223_P())) {
            return CommonMethods.empty();
        }
        return CommonMethods.full(ret);
    }

    public static Optional<Item> getItem(String fullName) {
        ExtendedResourceLocation location = ExtendedResourceLocation.complete(fullName);
        if (ForgeRegistries.BLOCKS.containsKey(location.strip())) {
            return CommonMethods.getBlockState(fullName).map(state -> Item.func_150898_a((Block)state.func_177230_c()));
        }
        return CommonMethods.nullable((Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)location));
    }

    public static Optional<ItemStack> getStack(String fullName) {
        ExtendedResourceLocation location = ExtendedResourceLocation.complete(fullName);
        return CommonMethods.getItem(location.strip().toString()).map(item -> new ItemStack(item, 1, location.getMeta()));
    }

    public static ItemStack toStack(IBlockState from) {
        Block block = from.func_177230_c();
        int meta = block.func_176201_c(from);
        return new ItemStack(block, 1, meta);
    }

    public static IBlockState toState(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        int meta = stack.func_77960_j();
        return block.func_176203_a(meta);
    }

    public static String formatStates(IBlockState fg, IBlockState bg) {
        StringBuilder sb = new StringBuilder(CommonMethods.formatState(fg));
        if (sb.length() > 0) {
            sb.append('_');
        }
        sb.append(CommonMethods.formatState(bg));
        return sb.toString();
    }

    public static String formatState(IBlockState state) {
        ResourceLocation registry = CommonMethods.nullable(state.func_177230_c().getRegistryName()).orElseThrow(() -> CommonMethods.runExF("Block not registered in time: {}.", state));
        int meta = state.func_177230_c().func_176201_c(state);
        return CommonMethods.formatBlock(registry, meta);
    }

    public static String formatFullState(String id) {
        ExtendedResourceLocation registry = ExtendedResourceLocation.complete(id);
        return CommonMethods.formatBlock(registry.strip(), registry.getMeta());
    }

    private static String formatBlock(ResourceLocation registry, int meta) {
        String mod = registry.func_110624_b();
        String block = registry.func_110623_a();
        StringBuilder sb = new StringBuilder();
        if (!mod.equals("minecraft")) {
            sb.append(mod);
        }
        if (!block.equals("stone")) {
            CommonMethods.appendSegment(sb, block);
        }
        if (meta != 0) {
            CommonMethods.appendSegment(sb, String.valueOf(meta));
        }
        return sb.toString();
    }

    private static void appendSegment(StringBuilder sb, String segment) {
        int length = sb.length();
        if (length > 0 && !sb.substring(length - 1).equals("_")) {
            sb.append("_");
        }
        sb.append(segment);
    }

    public static String ignoreData(String s) {
        int dataIndex = s.indexOf(123);
        if (dataIndex < 0) {
            dataIndex = s.length();
        }
        return s.substring(0, dataIndex);
    }
}

