/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.textures;

import com.personthecat.orestonevariants.io.BufferOutputStream;
import com.personthecat.orestonevariants.util.unsafe.Result;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.util.math.Vec3i;

public class ImageTools {
    private static final int OPACITY_THRESHOLD = 50;
    private static final int TRANSPARENCY_THRESHOLD = 17;
    private static final Color EMPTY_PIXEL = new Color(0, 0, 0, 0);
    private static final double MAX_DIFFERENCE = 441.673;
    private static final double MAX_ADJUSTMENT = 510.0;
    private static final double TEXTURE_SHARPEN_RATIO = 2.3;
    private static final int SHADE_OPACITY = 160;
    private static final int SHADE_CUTOFF = 108;

    public static Color[][] getOverlay(Color[][] bg, Color[][] fg) {
        Color[][] overlay = new Color[bg.length][bg[0].length];
        OverlayData data = new OverlayData(bg, fg);
        for (int x = 0; x < bg.length; ++x) {
            for (int y = 0; y < bg[0].length; ++y) {
                overlay[x][y] = ImageTools.getOrePixel(bg[x][y], fg[x][y], data);
            }
        }
        return overlay;
    }

    private static Color getOrePixel(Color bg, Color fg, OverlayData data) {
        double threshold;
        Vec3i stdDiff = ImageTools.subtract(bg, fg);
        double stdDist = ImageTools.getDistance(stdDiff);
        if (stdDist > 0.7 * data.maxDist) {
            return fg;
        }
        if (stdDist < 0.1 * data.maxDist) {
            return EMPTY_PIXEL;
        }
        Color darkened = ImageTools.darken(bg, 45);
        Vec3i darkDiff = ImageTools.subtract(darkened, fg);
        double darkDist = ImageTools.getDistance(darkDiff);
        if (darkDist < 0.125 * (data.maxRel + 0.001 / data.bgDist + 0.001)) {
            return EMPTY_PIXEL;
        }
        Vec3i diff = ImageTools.subtract(data.bgAvg, fg);
        double dist = ImageTools.getDistance(diff);
        double relDist = ImageTools.getRelativeDistance(diff);
        double d = threshold = data.bgDist > 0.05 ? 1.2 : 0.2;
        if (dist + relDist * 10.0 > threshold) {
            return fg;
        }
        return EMPTY_PIXEL;
    }

    public static Color[][] getOverlayManual(Color[][] bg, Color[][] fg, double threshold) {
        Color[][] overlay = new Color[bg.length][bg[0].length];
        OverlayData data = new OverlayData(bg, fg);
        for (int x = 0; x < bg.length; ++x) {
            for (int y = 0; y < bg[0].length; ++y) {
                overlay[x][y] = ImageTools.getOrePixelManual(bg[x][y], fg[x][y], data, threshold);
            }
        }
        return overlay;
    }

    private static Color getOrePixelManual(Color bg, Color fg, OverlayData data, double threshold) {
        double relDist;
        Vec3i stdDiff = ImageTools.subtract(bg, fg);
        double stdDist = ImageTools.getDistance(stdDiff);
        if (stdDist > 0.7 * data.maxDist) {
            return fg;
        }
        if (stdDist < 0.1 * data.maxDist) {
            return EMPTY_PIXEL;
        }
        Vec3i diff = ImageTools.subtract(data.bgAvg, fg);
        double dist = ImageTools.getDistance(diff);
        if (dist + (relDist = ImageTools.getRelativeDistance(diff)) * 10.0 > threshold) {
            return fg;
        }
        return EMPTY_PIXEL;
    }

    public static Color[][] shadeOverlay(Color[][] overlay, Color[][] bg, Color[][] fg, Color[][] mask) {
        Color[][] maskScaled = ImageTools.ensureSizeParity(mask, fg);
        Color[][] bgScaled = ImageTools.ensureSizeParity(bg, fg);
        Color[][] bgFilled = ImageTools.fillColors(bgScaled, ImageTools.getAverageColor(bg));
        Color[][] texturePixels = ImageTools.convertToPushAndPull(bgFilled, fg);
        Color[][] maskedTexture = ImageTools.removePixels(texturePixels, maskScaled);
        return ImageTools.overlay(maskedTexture, overlay);
    }

    public static Color[][] ensureSizeParity(Color[][] background, Color[][] foreground) {
        int w = foreground.length;
        background = ImageTools.getColors(ImageTools.scale(ImageTools.getImage(background), w, w));
        background = ImageTools.addFramesToBackground(background, foreground);
        return background;
    }

    public static Color[][] getColors(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        Color[][] colors = new Color[w][h];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                colors[x][y] = new Color(image.getRGB(x, y), true);
            }
        }
        return colors;
    }

    public static BufferedImage getImage(Color[][] image) {
        int w = image.length;
        int h = image[0].length;
        BufferedImage bi = new BufferedImage(w, h, 2);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                bi.setRGB(x, y, image[x][y].getRGB());
            }
        }
        return bi;
    }

    public static InputStream getStream(Color[][] image) {
        BufferOutputStream os = new BufferOutputStream();
        Result.of(() -> ImageIO.write((RenderedImage)ImageTools.getImage(image), "png", os)).expect("Unable to generate faux InputStream from color matrix.");
        return os.toInputStream();
    }

    public static Color[][] shiftImage(Color[][] image) {
        int w = image.length;
        int h = image[0].length;
        Color[][] shifted = new Color[w][h];
        int frames = h / w;
        assert (1.0 * (double)h / (double)w == (double)frames);
        for (int f = 0; f < frames; ++f) {
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < w; ++y) {
                    int imageY = f * w + y;
                    shifted[x][imageY] = ImageTools.getAverageColor(image[x][imageY], ImageTools.fromIndex(image, x - 1, imageY, f), ImageTools.fromIndex(image, x + 1, imageY, f), ImageTools.fromIndex(image, x, imageY - 1, f), ImageTools.fromIndex(image, x, imageY + 1, f));
                }
            }
        }
        return shifted;
    }

    private static Color getAverageColor(Color[][] image) {
        return ImageTools.getAverageColor(ImageTools.matrixToArray(image));
    }

    private static Color getAverageColor(Color ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        int count = 0;
        for (Color color : colors) {
            if (color.getAlpha() <= 50) continue;
            r += color.getRed();
            g += color.getGreen();
            b += color.getBlue();
            ++count;
        }
        if (count == 0) {
            return EMPTY_PIXEL;
        }
        return new Color(r / count, g / count, b / count);
    }

    private static Color[] matrixToArray(Color[][] matrix) {
        Color[] array = new Color[matrix.length * matrix[0].length];
        int index = 0;
        for (int x = 0; x < matrix.length; ++x) {
            for (int y = 0; y < matrix[0].length; ++y) {
                array[index++] = matrix[x][y];
            }
        }
        return array;
    }

    private static double getMaxDistance(Color[][] image, Color[][] from) {
        double num = 0.0;
        for (int x = 0; x < image.length; ++x) {
            for (int y = 0; y < image[0].length; ++y) {
                if (image[x][y].getAlpha() <= 17) continue;
                num = Math.max(num, ImageTools.getDistance(image[x][y], from[x][y]));
            }
        }
        return num;
    }

    private static double getAverageDistance(Color[][] image) {
        double sum = 0.0;
        for (int x = 0; x < image.length - 1; ++x) {
            for (int y = 0; y < image[0].length - 1; ++y) {
                sum += ImageTools.getDistance(image[x][y], image[x + 1][y]);
                sum += ImageTools.getDistance(image[x][y], image[x][y + 1]);
            }
        }
        return sum / (double)(image.length * image[0].length * 2);
    }

    private static Vec3i subtract(Color background, Color foreground) {
        int r = foreground.getRed() - background.getRed();
        int g = foreground.getGreen() - background.getGreen();
        int b = foreground.getBlue() - background.getBlue();
        return new Vec3i(r, g, b);
    }

    private static double getDistance(Vec3i difference) {
        int r = difference.func_177958_n();
        int g = difference.func_177956_o();
        int b = difference.func_177952_p();
        return Math.sqrt(r * r + g * g + b * b) / 441.673;
    }

    private static double getRelativeDistance(Vec3i difference) {
        int rO = difference.func_177958_n();
        int gO = difference.func_177956_o();
        int bO = difference.func_177952_p();
        int min = Math.min(Math.min(rO, gO), bO);
        int rS = rO - min;
        int gS = gO - min;
        int bS = bO - min;
        return Math.sqrt(rS * rS + gS * gS + bS * bS) / 510.0;
    }

    private static double getMaxRelDist(Color[][] background, Color[][] foreground) {
        double num = 0.0;
        for (int x = 0; x < background.length; ++x) {
            for (int y = 0; y < background[0].length; ++y) {
                Vec3i diff = ImageTools.subtract(background[x][y], foreground[x][y]);
                num = Math.max(num, ImageTools.getRelativeDistance(diff));
            }
        }
        return num;
    }

    private static Color darken(Color c, int amount) {
        int r = c.getRed() - amount;
        int g = c.getGreen() - amount;
        int b = c.getBlue() - amount;
        r = Math.max(r, 0);
        g = Math.max(g, 0);
        b = Math.max(b, 0);
        return new Color(r, g, b);
    }

    private static double getDistance(Color background, Color foreground) {
        int r = foreground.getRed() - background.getRed();
        int g = foreground.getGreen() - background.getGreen();
        int b = foreground.getBlue() - background.getBlue();
        return Math.sqrt(r * r + g * g + b * b) / 441.673;
    }

    private static Color[][] fillColors(Color[][] image, Color color) {
        for (int x = 0; x < image.length; ++x) {
            for (int y = 0; y < image[0].length; ++y) {
                image[x][y] = color;
            }
        }
        return image;
    }

    private static Color[][] addFramesToBackground(Color[][] background, Color[][] foreground) {
        int w = background.length;
        int h = background[0].length;
        int nh = foreground[0].length;
        int frames = nh / h;
        Color[][] newBackground = new Color[w][h * frames];
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                for (int i = 0; i < frames; ++i) {
                    newBackground[x][h * i + y] = background[x][y];
                }
            }
        }
        return newBackground;
    }

    private static Color[][] convertToPushAndPull(Color[][] background, Color[][] foreground) {
        Color[][] image = new Color[foreground.length][foreground[0].length];
        for (int x = 0; x < foreground.length; ++x) {
            for (int y = 0; y < foreground[0].length; ++y) {
                int alpha = (int)(160.0 * ImageTools.getDistance(foreground[x][y], background[x][y]));
                if (alpha > 108) {
                    alpha = 108;
                } else if (alpha < 0) {
                    alpha = 0;
                }
                image[x][y] = ImageTools.isPixelDarker(background[x][y], foreground[x][y]) ? new Color(0, 0, 0, alpha) : new Color(255, 255, 255, alpha);
            }
        }
        return image;
    }

    private static boolean isPixelDarker(Color background, Color foreground) {
        int bgTotal;
        int fgTotal = Math.abs(foreground.getRed() + foreground.getGreen() + foreground.getBlue());
        return fgTotal < (bgTotal = Math.abs(background.getRed() + background.getGreen() + background.getBlue()));
    }

    private static Color[][] removePixels(Color[][] image, Color[][] mask) {
        for (int x = 0; x < image.length; ++x) {
            for (int y = 0; y < image[0].length; ++y) {
                int r = image[x][y].getRed();
                int g = image[x][y].getGreen();
                int b = image[x][y].getBlue();
                int a = (int)((double)image[x][y].getAlpha() * (1.0 - (double)mask[x][y].getAlpha() / 255.0));
                if (a < 0) {
                    a = 0;
                } else if (a > 255) {
                    a = 255;
                }
                image[x][y] = new Color(r, g, b, a);
            }
        }
        return image;
    }

    private static Color[][] overlay(Color[][] background, Color[][] foreground) {
        for (int x = 0; x < foreground.length; ++x) {
            for (int y = 0; y < foreground[0].length; ++y) {
                foreground[x][y] = ImageTools.blendPixels(background[x][y], foreground[x][y]);
            }
        }
        return foreground;
    }

    private static Color blendPixels(Color bg, Color fg) {
        int b;
        int g;
        int r;
        if (fg.getAlpha() > 50) {
            r = fg.getRed();
            g = fg.getGreen();
            b = fg.getBlue();
        } else {
            r = (fg.getRed() * fg.getAlpha() + bg.getRed() * (255 - fg.getAlpha())) / 255;
            g = (fg.getGreen() * fg.getAlpha() + bg.getGreen() * (255 - fg.getAlpha())) / 255;
            b = (fg.getBlue() * fg.getAlpha() + bg.getBlue() * (255 - fg.getAlpha())) / 255;
        }
        int a = fg.getAlpha() + bg.getAlpha();
        if (a < 17 && r == 255 && g == 255 && b == 255) {
            return EMPTY_PIXEL;
        }
        a = ImageTools.limitRange((int)((double)a * 2.3));
        return new Color(r, g, b, a);
    }

    private static Color fromIndex(Color[][] image, int x, int y, int frame) {
        int w = image.length;
        return x < 0 || y < frame * w || x >= w || y >= (frame + 1) * w || image[x][y].getAlpha() == 34 ? EMPTY_PIXEL : image[x][y];
    }

    private static BufferedImage scale(BufferedImage image, int x, int y) {
        BufferedImage scaled = new BufferedImage(x, y, image.getType());
        Graphics2D graphics = scaled.createGraphics();
        graphics.drawImage(image, 0, 0, x, y, null);
        graphics.dispose();
        return scaled;
    }

    private static int limitRange(int channel) {
        return channel < 0 ? 0 : Math.min(channel, 255);
    }

    private static class OverlayData {
        private final Color bgAvg;
        private final double bgDist;
        private final double maxDist;
        private final double maxRel;

        OverlayData(Color[][] bg, Color[][] fg) {
            this.bgAvg = ImageTools.getAverageColor(bg);
            this.bgDist = ImageTools.getAverageDistance(bg);
            this.maxDist = ImageTools.getMaxDistance(bg, fg);
            this.maxRel = ImageTools.getMaxRelDist(bg, fg);
        }
    }
}

