/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.recipes;

import com.personthecat.orestonevariants.Main;
import com.personthecat.orestonevariants.blocks.BaseOreVariant;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.properties.RecipeProperties;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.unsafe.ReflectionTools;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IRegistryDelegate;

public class RecipeHelper {
    public static final Map<Integer, List<Integer>> stackToId = (Map)ReflectionTools.getValue(OreDictionary.class, "stackToId", "", 6, null);
    public static final List<String> idToName = (List)ReflectionTools.getValue(OreDictionary.class, "idToName", "", 2, null);

    public static void handleRecipes() {
        if (Cfg.BlocksCat.enableFurnaceRecipes) {
            RecipeHelper.registerRecipes();
        }
        if (Cfg.BlocksCat.enableOreDictionary) {
            RecipeHelper.registerOreDict();
        }
    }

    private static void registerRecipes() {
        for (RecipeProperties recipe : RecipeProperties.setupRecipes()) {
            RecipeHelper.getBlocksForRecipe(recipe).forEach(block -> {
                ItemStack stack = block.getStack();
                GameRegistry.addSmelting((ItemStack)stack, (ItemStack)recipe.result, (float)recipe.xp);
                IBlockState denseState = block.func_176223_P().func_177226_a((IProperty)BaseOreVariant.DENSE, (Comparable)Boolean.valueOf(true));
                int multiple = Cfg.DenseCat.smeltMultiplier;
                ItemStack denseStack = block.getStack(denseState);
                ItemStack denseResult = recipe.result.func_77946_l();
                denseResult.func_190920_e(multiple);
                GameRegistry.addSmelting((ItemStack)denseStack, (ItemStack)denseResult, (float)(recipe.xp * (float)multiple));
            });
        }
        CommonMethods.info("Successfully setup all recipes with GameRegistry!", new Object[0]);
    }

    private static void registerOreDict() {
        for (BaseOreVariant ore : Main.BLOCKS) {
            IBlockState bgBlock = ore.properties.ore.get();
            List<String> names = RecipeHelper.getRegisteredNames(CommonMethods.toStack(bgBlock));
            RecipeHelper.debugNames(bgBlock, names);
            for (String name : names) {
                ItemStack stack = ore.getStack();
                OreDictionary.registerOre((String)name, (ItemStack)stack);
                IBlockState denseState = ore.func_176223_P().func_177226_a((IProperty)BaseOreVariant.DENSE, (Comparable)Boolean.valueOf(true));
                ItemStack denseStack = ore.getStack(denseState);
                OreDictionary.registerOre((String)("dense" + name), (ItemStack)denseStack);
                OreDictionary.registerOre((String)(name + "Dense"), (ItemStack)denseStack);
            }
        }
    }

    private static void debugNames(IBlockState bgBlock, List<String> names) {
        CommonMethods.info("Found the following names registered to {}:", bgBlock);
        for (String name : names) {
            CommonMethods.info(" * {}", name);
        }
    }

    private static List<String> getRegisteredNames(ItemStack ore) {
        List<String> names = CommonMethods.list(new String[0]);
        int hash = RecipeHelper.getItemHash(ore);
        List<Integer> ids = stackToId.get(hash);
        if (ids == null) {
            CommonMethods.info("No item ids found for {}. Skipping OreDict registry.", ore);
            return names;
        }
        for (Integer i : ids) {
            names.add(idToName.get(i));
        }
        return names;
    }

    private static int getItemHash(ItemStack ore) {
        IRegistryDelegate delegate = ore.func_77973_b().delegate;
        int hash = Item.field_150901_e.func_148757_b((Object)((Item)delegate.get()));
        if (ore.func_77952_i() != Short.MAX_VALUE) {
            hash |= ore.func_77952_i() + 1 << 16;
        }
        return hash;
    }

    private static Stream<BaseOreVariant> getBlocksForRecipe(RecipeProperties recipe) {
        return Main.BLOCKS.stream().filter(b -> recipe.input.func_77969_a(CommonMethods.toStack(b.properties.ore.get())));
    }

    public static void forEachRecipe(BiConsumer<ItemStack, ItemStack> fun) {
        FurnaceRecipes.func_77602_a().func_77599_b().forEach(fun);
    }

    public static Optional<ItemStack> resultOf(ItemStack item) {
        FurnaceRecipes instance = FurnaceRecipes.func_77602_a();
        return CommonMethods.nullable(instance.func_151395_a(item));
    }

    public static Optional<ItemStack> resultOf(Item item) {
        return RecipeHelper.resultOf(new ItemStack(item));
    }

    public static float getExperience(ItemStack result) {
        return FurnaceRecipes.func_77602_a().func_151398_b(result);
    }
}

