/*
 * Decompiled with CFR 0.152.
 */
package com.personthecat.orestonevariants.properties;

import com.google.common.collect.ImmutableSet;
import com.personthecat.orestonevariants.config.Cfg;
import com.personthecat.orestonevariants.util.CommonMethods;
import com.personthecat.orestonevariants.util.HjsonTools;
import com.personthecat.orestonevariants.util.InvertableSet;
import com.personthecat.orestonevariants.util.Lazy;
import com.personthecat.orestonevariants.util.Range;
import com.personthecat.orestonevariants.world.WildcardBiome;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.Biome;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

public class WorldGenProperties {
    public final double denseRatio;
    public final int size;
    public final int count;
    public final double chance;
    public final Range height;
    public final Lazy<Integer> ID;
    public final Lazy<InvertableSet<Biome>> biomes;
    public final InvertableSet<Integer> dimensions;
    public static final Integer DIM_WILDCARD = Integer.MAX_VALUE;
    public static final Biome BIOME_WILDCARD = new WildcardBiome();

    public WorldGenProperties(String lookup, JsonObject json) {
        this(lookup, json, HjsonTools.getObjectOrNew(json, "biomes"));
    }

    private WorldGenProperties(String lookup, JsonObject main, JsonObject biomes) {
        this(lookup, HjsonTools.getFloatOr(main, "denseChance", (float)Cfg.DenseCat.chance), HjsonTools.getIntOr(main, "size", 8), HjsonTools.getIntOr(main, "count", 2), HjsonTools.getFloatOr(main, "chance", 1.0f), HjsonTools.getRangeOr(main, "height", new Range(0, 32)), HjsonTools.getStringArrayOrEmpty(biomes, "names"), HjsonTools.getStringArrayOrEmpty(biomes, "types"), HjsonTools.getBoolOr(main, "blacklistBiomes", false), HjsonTools.getIntArrayOrEmpty(main, "dimensions"), HjsonTools.getBoolOr(main, "blacklistDimensions", false));
    }

    public WorldGenProperties(String lookup, double denseRatio, int size, int count, double chance, Range height, List<String> biomes, List<String> biomeTypes, boolean blacklistBiomes, int[] dimensions, boolean blacklistDims) {
        if (Cfg.WorldCat.largeClusters) {
            if (size < 4) {
                count *= 20;
            } else if (count > 1) {
                count /= 2;
                size = 45;
            } else {
                size = 25;
            }
        }
        this.ID = new Lazy<Supplier<Integer>>(() -> WorldGenProperties.getStateId(lookup));
        this.denseRatio = denseRatio;
        this.size = size;
        this.count = count;
        this.chance = chance;
        this.height = height;
        this.biomes = new Lazy<Supplier<InvertableSet>>(() -> WorldGenProperties.getAllBiomes(biomes, biomeTypes, blacklistBiomes));
        this.dimensions = WorldGenProperties.getDimSet(dimensions, blacklistDims);
    }

    public boolean canSpawn(int dim, Biome b) {
        return this.dimensions.check(dim) && this.biomes.get().check(b);
    }

    private static int getStateId(String lookup) {
        IBlockState state = CommonMethods.getBlockState(lookup).orElseThrow(() -> CommonMethods.runExF("No block state found for: {}.", lookup));
        return Block.func_176210_f((IBlockState)state);
    }

    private static InvertableSet<Biome> getAllBiomes(List<String> names, List<String> types, boolean blacklist) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        names.forEach(name -> builder.add((Object)CommonMethods.getBiome(name).orElseThrow(() -> HjsonTools.noBiomeNamed(name))));
        types.forEach(type -> builder.addAll(Arrays.asList(CommonMethods.getBiomes(CommonMethods.getBiomeType(type)))));
        if (names.isEmpty() && types.isEmpty() && !blacklist) {
            builder.add((Object)BIOME_WILDCARD);
        }
        if (!Cfg.WorldCat.biomeSpecific) {
            blacklist = true;
        }
        return InvertableSet.wrap(builder.build()).setBlacklist(blacklist);
    }

    private static InvertableSet<Integer> getDimSet(int[] dimensions, boolean blacklist) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (int i : dimensions) {
            builder.add((Object)i);
        }
        if (dimensions.length == 0 && !blacklist) {
            builder.add((Object)DIM_WILDCARD);
        }
        return InvertableSet.wrap(builder.build()).setBlacklist(blacklist);
    }

    public static List<WorldGenProperties> list(String lookup, JsonArray array) {
        ArrayList<WorldGenProperties> list = new ArrayList<WorldGenProperties>();
        for (JsonValue value : array) {
            list.add(new WorldGenProperties(lookup, value.asObject()));
        }
        return list;
    }
}

